/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.utils.LogHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public class EAICommand {
    public static final SuggestionProvider<CommandSourceStack> DATA = SuggestionProviders.m_121658_((ResourceLocation)EnhancedAI.location("data"), (context, builder) -> SharedSuggestionProvider.m_82957_(EAIData.DATA.stream().map(EAIData::id), (SuggestionsBuilder)builder));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher, CommandBuildContext pContext) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"enhancedai").requires(p_138819_ -> p_138819_.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"data", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(DATA).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Object parsed;
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"data");
            String valueStr = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            Optional<EAIData> optData = EAIData.DATA.stream().filter(d -> d.id().equals((Object)id)).findFirst();
            if (optData.isEmpty()) {
                return 0;
            }
            EAIData data = optData.get();
            try {
                parsed = data.parse(valueStr);
            }
            catch (Exception ex) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid value for data " + String.valueOf(data.id()))));
                return 0;
            }
            Entity entity = EntityArgument.m_91452_((CommandContext)ctx, (String)"target");
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                EAIData.apply(data, mob, parsed);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Changed %s to %s".formatted(data.id(), parsed)), true);
            return 1;
        })))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"data", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(DATA).executes(ctx -> {
            Entity entity;
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"data");
            Optional<EAIData> optData = EAIData.DATA.stream().filter(d -> d.id().equals((Object)id)).findFirst();
            if (optData.isEmpty()) {
                return 0;
            }
            EAIData data = optData.get();
            if (!data.has(entity = EntityArgument.m_91452_((CommandContext)ctx, (String)"target"))) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Entity does not have data " + String.valueOf(data.id()))));
                return 0;
            }
            Object value = data.get(entity);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)String.valueOf(value)), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"list_data_keys").executes(ctx -> {
            EAIData.DATA.forEach(d -> LogHelper.info(d.id().toString(), new Object[0]));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Logged list of data keys"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"list_goals").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)ctx, (String)"target");
            if (!(entity instanceof Mob)) {
                return 0;
            }
            Mob mob = (Mob)entity;
            MutableComponent component = Component.m_237113_((String)("Goals for " + entity.m_7755_().getString()));
            component.m_7220_(CommonComponents.f_178388_).m_7220_((Component)Component.m_237113_((String)"Goal Selector: "));
            ArrayList<WrappedGoal> availableGoals = new ArrayList<WrappedGoal>(mob.f_21345_.f_25345_);
            availableGoals.sort(Comparator.comparingInt(WrappedGoal::m_26012_));
            for (WrappedGoal goal : availableGoals) {
                MutableComponent componentGoal = Component.m_237113_((String)("(" + goal.m_26012_() + ") " + goal.m_26015_().getClass().getSimpleName() + "  " + String.valueOf(goal.m_7684_())));
                if (goal.m_7620_()) {
                    componentGoal.m_130940_(ChatFormatting.GREEN);
                }
                component.m_7220_(CommonComponents.f_178388_).m_7220_(CommonComponents.f_263701_).m_7220_((Component)componentGoal);
            }
            component.m_7220_(CommonComponents.f_178388_).m_7220_(CommonComponents.f_178388_).m_7220_((Component)Component.m_237113_((String)"Target Selector: "));
            ArrayList<WrappedGoal> targetGoals = new ArrayList<WrappedGoal>(mob.f_21346_.f_25345_);
            targetGoals.sort(Comparator.comparingInt(WrappedGoal::m_26012_));
            for (WrappedGoal goal : targetGoals) {
                MutableComponent componentGoal = Component.m_237113_((String)("(" + goal.m_26012_() + ") " + goal.m_26015_().getClass().getSimpleName() + "  " + String.valueOf(goal.m_7684_())));
                if (goal.m_7620_()) {
                    componentGoal.m_130940_(ChatFormatting.GREEN);
                }
                component.m_7220_(CommonComponents.f_178388_).m_7220_(CommonComponents.f_263701_).m_7220_((Component)componentGoal);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> component, true);
            return 1;
        }))));
    }
}

