/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.data;

import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class EAIDataList<T>
extends EAIData<List<T>> {
    private final Class<T> elementType;

    private EAIDataList(ResourceLocation id, BiConsumer<Mob, List<T>> onChange, Class<T> elementType) {
        super(id, onChange, List.class);
        this.elementType = elementType;
    }

    @Override
    public void apply(Mob mob, List<T> value) {
        ListTag listTag = this.toListTag(value);
        ModNBTData.put((Entity)mob, (ResourceLocation)this.id(), (Object)listTag);
        this.onChange().accept(mob, (Mob)value);
    }

    @Override
    public List<T> get(Entity entity) {
        int nbtType = this.nbtTypeFor(this.elementType);
        ListTag listTag = ModNBTData.getList((Entity)entity, (ResourceLocation)this.id(), (int)nbtType);
        return this.fromListTag(listTag);
    }

    private ListTag toListTag(List<T> list) {
        ListTag listTag = new ListTag();
        if (this.elementType == String.class) {
            for (T e : list) {
                listTag.add((Object)StringTag.m_129297_((String)((String)e)));
            }
        } else if (this.elementType == Integer.class) {
            for (T e : list) {
                listTag.add((Object)IntTag.m_128679_((int)((Integer)e)));
            }
        } else if (this.elementType == Double.class) {
            for (T e : list) {
                listTag.add((Object)DoubleTag.m_128500_((double)((Double)e)));
            }
        } else if (this.elementType == Boolean.class) {
            for (T e : list) {
                listTag.add((Object)ByteTag.m_128266_((byte)((Boolean)e != false ? (byte)1 : 0)));
            }
        } else {
            throw new IllegalArgumentException("Unsupported element type: " + String.valueOf(this.elementType));
        }
        return listTag;
    }

    private List<T> fromListTag(ListTag listTag) {
        ArrayList<T> list = new ArrayList<T>();
        if (this.elementType == String.class) {
            for (Tag t : listTag) {
                list.add(this.elementType.cast(t.m_7916_()));
            }
        } else if (this.elementType == Integer.class) {
            for (Tag t : listTag) {
                list.add(this.elementType.cast(((IntTag)t).m_7047_()));
            }
        } else if (this.elementType == Double.class) {
            for (Tag t : listTag) {
                list.add(this.elementType.cast(((DoubleTag)t).m_7061_()));
            }
        } else if (this.elementType == Boolean.class) {
            for (Tag t : listTag) {
                list.add(this.elementType.cast(((ByteTag)t).m_7063_() != 0));
            }
        } else {
            throw new IllegalArgumentException("Unsupported element type: " + String.valueOf(this.elementType));
        }
        return list;
    }

    private int nbtTypeFor(Class<T> clazz) {
        if (clazz == String.class) {
            return 8;
        }
        if (clazz == Integer.class) {
            return 3;
        }
        if (clazz == Double.class) {
            return 6;
        }
        if (clazz == Boolean.class) {
            return 1;
        }
        throw new IllegalArgumentException("Unsupported element type: " + String.valueOf(clazz));
    }

    public static <E> EAIDataList<E> of(ResourceLocation id, Class<E> elementType) {
        return EAIDataList.of(id, elementType, (mob, list) -> {});
    }

    public static <E> EAIDataList<E> of(ResourceLocation id, Class<E> elementType, BiConsumer<Mob, List<E>> onChange) {
        EAIDataList data = new EAIDataList(id, onChange, elementType);
        DATA.add(data);
        return data;
    }

    public Class<T> elementType() {
        return this.elementType;
    }

    @Override
    public List<T> parse(String input) {
        String[] parts = input.split(",");
        ArrayList<T> result = new ArrayList<T>();
        for (String part : parts) {
            if (this.elementType == String.class) {
                result.add(this.elementType.cast(part.trim()));
                continue;
            }
            if (this.elementType == Integer.class) {
                result.add(this.elementType.cast(Integer.parseInt(part.trim())));
                continue;
            }
            if (this.elementType == Double.class) {
                result.add(this.elementType.cast(Double.parseDouble(part.trim())));
                continue;
            }
            if (this.elementType == Boolean.class) {
                result.add(this.elementType.cast(Boolean.parseBoolean(part.trim())));
                continue;
            }
            throw new IllegalStateException("Unsupported element type: " + String.valueOf(this.elementType));
        }
        return result;
    }
}

