/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAIAvoidEntityGoal;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.mixin.accessors.MeleeAttackGoalAccessor;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.targeting.EAINearestAttackableTarget;
import insane96mcp.enhancedai.setup.EAIAttributes;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:animal", description="Make animals fight back or be scared by players. Use the entity type tag enhancedai:animal/scared_attack/can_be_neutral, enhancedai:animal/scared_attack/can_be_hostile, and enhancedai:animal/scared_attack/can_be_scared_by_players to add/remove animals.")
public class AnimalScaredAttack
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_NEUTRAL = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("animal/scared_attack/can_be_neutral"));
    public static final TagKey<EntityType<?>> CAN_BE_HOSTILE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("animal/scared_attack/can_be_hostile"));
    public static final TagKey<EntityType<?>> SCARED_BY_PLAYERS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("animal/scared_attack/can_be_scared_by_players"));
    public static final UUID FOLLOW_RANGE_REDUCTION_UUID = UUID.fromString("62e016b0-90d0-4e72-9d40-fffac566df20");
    @Config(min=0.0, max=1.0, description="Animals have this percentage chance to be able to fight back instead of fleeing. Animals have a slightly bigger range to attack. Attack damage can't be changed via config due to limitations so use mods like Mobs Properties Randomness to change the damage. Base damage is 3")
    public static Double neutralChance = 0.35;
    @Config(min=0.0, max=1.0, description="Animals have this percentage chance to be hostile. Hostile animals are also neutral.")
    public static Double hostileChance = 0.1;
    @Config(min=0.0, max=4.0, description="Movement speed multiplier when aggroed.")
    public static Double speedModifier = 1.1;
    @Config(min=0.0, max=1.0, description="Animals have this percentage chance to be scared by players and run away. Fight back chance has priority over this")
    public static Double playersScaredChance = 0.25;
    @Config(min=0.0, max=32.0, description="Distance from a player that will make the entity run away. Higher values might impact performance")
    public static Integer fleeDistanceFar = 12;
    @Config(min=0.0, max=32.0, description="Distance from a player that counts as near and will make the entity run away faster. Higher values might impact performance")
    public static Integer fleeDistanceNear = 7;
    @Config(min=0.0, max=4.0, description="Speed multiplier when the animal avoids the player when it's within 'Flee Distance Far' blocks from them.")
    public static Double fleeSpeedFar = 1.1;
    @Config(min=0.0, max=4.0, description="Speed multiplier when the animal avoids the player and it's within 'Flee Distance Near' blocks from them.")
    public static Double fleeSpeedNear = 1.2;
    @Config(min=0.0, max=128.0, description="Animals' knockback attribute will be set to this value multiplied by their bounding box size (bigger mobs have higher knockback). 0 disables this and lets you customize knockback per mob with attribute modifiers.")
    public static Double knockback = 1.4;
    @Config(description="Animals' knockback attribute will be increased/decreased based on the size of the mob.")
    public static Boolean knockbackSizeBased = true;
    private static final double BASE_ATTACK_DAMAGE = 3.0;
    public static EAIData<Boolean> NEUTRAL;
    public static EAIData<Boolean> HOSTILE;
    public static EAIData<Boolean> PLAYER_SCARED;
    public static EAIData<Double> ATTACK_MOVEMENT_SPEED_MODIFIER;
    public static EAIData<Integer> FLEE_DISTANCE_FAR;
    public static EAIData<Integer> FLEE_DISTANCE_NEAR;
    public static EAIData<Double> FLEE_SPEED_FAR;
    public static EAIData<Double> FLEE_SPEED_NEAR;
    public static EAIData<Integer> HORIZONTAL_FLEE_DISTANCE;
    public static EAIData<Integer> VERTICAL_FLEE_DISTANCE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        NEUTRAL = EAIData.ofBool(this.createDataKey("neutral"), (mob, neutral) -> {
            if (!(mob instanceof PathfinderMob)) {
                return;
            }
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            GoalHelper.removeGoal(mob.f_21346_, HurtByTargetGoal.class);
            GoalHelper.removeGoal(mob.f_21345_, AnimalMeleeAttackGoal.class);
            if (neutral.booleanValue()) {
                mob.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(pathfinderMob, new Class[0]).m_26044_(new Class[0]));
                mob.f_21345_.m_25352_(1, (Goal)new AnimalMeleeAttackGoal(pathfinderMob, ATTACK_MOVEMENT_SPEED_MODIFIER.get((Entity)mob), true));
            }
        });
        HOSTILE = EAIData.ofBool(this.createDataKey("hostile"), (mob, hostile) -> {
            GoalHelper.removeGoal(mob.f_21346_, AnimalNearestAttackableTargetGoal.class);
            mob.m_21051_(Attributes.f_22277_).m_22120_(FOLLOW_RANGE_REDUCTION_UUID);
            mob.m_21051_((Attribute)EAIAttributes.XRAY_FOLLOW_RANGE.get()).m_22120_(FOLLOW_RANGE_REDUCTION_UUID);
            if (hostile.booleanValue()) {
                NEUTRAL.apply((Mob)mob, true);
                MCUtils.applyModifier((LivingEntity)mob, (Attribute)Attributes.f_22277_, (UUID)FOLLOW_RANGE_REDUCTION_UUID, (String)"Reduced follow range for hostile Animals", (double)-0.75, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)true);
                MCUtils.applyModifier((LivingEntity)mob, (Attribute)((Attribute)EAIAttributes.XRAY_FOLLOW_RANGE.get()), (UUID)FOLLOW_RANGE_REDUCTION_UUID, (String)"Reduced follow range for hostile Animals", (double)-0.75, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)true);
                mob.f_21346_.m_25352_(2, new AnimalNearestAttackableTargetGoal<Player>((Mob)mob, Player.class, false, false));
                PLAYER_SCARED.apply((Mob)mob, false);
                ATTACK_MOVEMENT_SPEED_MODIFIER.changed((Mob)mob);
            }
        });
        PLAYER_SCARED = EAIData.ofBool(this.createDataKey("player_scared"), (mob, scared) -> {
            if (!(mob instanceof PathfinderMob)) {
                return;
            }
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            GoalHelper.removeGoal(mob.f_21345_, AnimalAvoidPlayersGoal.class);
            if (scared.booleanValue()) {
                pathfinderMob.f_21345_.m_25352_(1, (Goal)new AnimalAvoidPlayersGoal(pathfinderMob, FLEE_DISTANCE_FAR, FLEE_DISTANCE_NEAR, FLEE_SPEED_FAR, FLEE_SPEED_NEAR, HORIZONTAL_FLEE_DISTANCE, VERTICAL_FLEE_DISTANCE));
            }
        });
        ATTACK_MOVEMENT_SPEED_MODIFIER = EAIData.ofDouble(this.createDataKey("attack_movement_speed_mod"), (mob, value) -> GoalHelper.getGoal(mob.f_21345_, AnimalMeleeAttackGoal.class).ifPresent(animalMeleeAttackGoal -> ((MeleeAttackGoalAccessor)((Object)animalMeleeAttackGoal)).setSpeedModifier((double)value)));
        FLEE_DISTANCE_FAR = EAIData.ofInt(this.createDataKey("flee_distance_far"));
        FLEE_DISTANCE_NEAR = EAIData.ofInt(this.createDataKey("flee_distance_near"));
        FLEE_SPEED_FAR = EAIData.ofDouble(this.createDataKey("flee_speed_far"));
        FLEE_SPEED_NEAR = EAIData.ofDouble(this.createDataKey("flee_speed_near"));
        HORIZONTAL_FLEE_DISTANCE = EAIData.ofInt(this.createDataKey("horizontal_flee_distance"));
        VERTICAL_FLEE_DISTANCE = EAIData.ofInt(this.createDataKey("vertical_flee_distance"));
    }

    public static void attribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, Attributes.f_22281_)) continue;
            event.add(entityType, Attributes.f_22281_, 3.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        if (knockback > 0.0) {
            AttributeInstance kbAttribute;
            double baseSize = 1.053;
            double actualKnockback = knockback;
            if (knockbackSizeBased.booleanValue()) {
                actualKnockback = (double)(animal.m_20205_() * animal.m_20205_() * animal.m_20206_()) * knockback / baseSize;
            }
            if ((kbAttribute = animal.m_21051_(Attributes.f_22282_)) != null) {
                kbAttribute.m_22125_(new AttributeModifier("Animal knockback", actualKnockback, AttributeModifier.Operation.ADDITION));
            }
        }
        ATTACK_MOVEMENT_SPEED_MODIFIER.applyIfAbsent((Mob)animal, speedModifier);
        NEUTRAL.applyIfAbsent((Mob)animal, animal.m_6095_().m_204039_(CAN_BE_NEUTRAL) && animal.m_217043_().m_188500_() < neutralChance);
        HOSTILE.applyIfAbsent((Mob)animal, animal.m_6095_().m_204039_(CAN_BE_HOSTILE) && animal.m_217043_().m_188500_() < hostileChance);
        PLAYER_SCARED.applyIfAbsent((Mob)animal, HOSTILE.get((Entity)animal) == false && animal.m_6095_().m_204039_(SCARED_BY_PLAYERS) && animal.m_217043_().m_188500_() < playersScaredChance);
        FLEE_DISTANCE_FAR.applyIfAbsent((Mob)animal, fleeDistanceFar);
        FLEE_DISTANCE_NEAR.applyIfAbsent((Mob)animal, fleeDistanceNear);
        FLEE_SPEED_FAR.applyIfAbsent((Mob)animal, fleeSpeedFar);
        FLEE_SPEED_NEAR.applyIfAbsent((Mob)animal, fleeSpeedNear);
        HORIZONTAL_FLEE_DISTANCE.applyIfAbsent((Mob)animal, 12);
        VERTICAL_FLEE_DISTANCE.applyIfAbsent((Mob)animal, 7);
    }

    public static class AnimalMeleeAttackGoal
    extends MeleeAttackGoal {
        public AnimalMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            OwnableEntity ownableEntity;
            PathfinderMob pathfinderMob = this.f_25540_;
            if (pathfinderMob instanceof OwnableEntity && (ownableEntity = (OwnableEntity)pathfinderMob).m_269323_() != null) {
                return false;
            }
            return !this.f_25540_.m_6162_() && super.m_8036_();
        }
    }

    public static class AnimalAvoidPlayersGoal
    extends EAIAvoidEntityGoal<Player> {
        public AnimalAvoidPlayersGoal(PathfinderMob entity, EAIData<Integer> avoidDistanceFar, EAIData<Integer> avoidDistanceNear, EAIData<Double> farSpeed, EAIData<Double> nearSpeed, EAIData<Integer> horizontalDistance, EAIData<Integer> verticalDistance) {
            super(new EAIAvoidEntityGoal.Builder<Player>(entity, Player.class, avoidDistanceFar, avoidDistanceNear, farSpeed, nearSpeed, horizontalDistance, verticalDistance));
        }

        @Override
        public boolean m_8036_() {
            OwnableEntity ownableEntity;
            PathfinderMob pathfinderMob = this.goalOwner;
            if (pathfinderMob instanceof OwnableEntity && (ownableEntity = (OwnableEntity)pathfinderMob).m_269323_() != null) {
                return false;
            }
            return super.m_8036_();
        }
    }

    public static class AnimalNearestAttackableTargetGoal<T extends LivingEntity>
    extends EAINearestAttackableTarget<T> {
        public AnimalNearestAttackableTargetGoal(Mob goalOwnerIn, Class<T> targetClassIn, boolean mustSee, boolean mustReach) {
            super(goalOwnerIn, targetClassIn, mustSee, mustReach, TargetingConditions.m_148352_());
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !this.f_26135_.m_6162_();
        }
    }
}

