/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper.swell;

import insane96mcp.enhancedai.ai.BetaStrafe;
import insane96mcp.enhancedai.modules.creeper.CreeperUtils;
import insane96mcp.enhancedai.modules.creeper.swell.CreeperSwell;
import insane96mcp.enhancedai.modules.mobs.avoidexplosion.AvoidExplosionGoal;
import insane96mcp.insanelib.util.MCUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.Vec3;

public class EAICreeperSwellGoal
extends Goal {
    private static final UUID WALKING_FUSE_SPEED_MODIFIER_UUID = UUID.fromString("ab376fec-5a15-4d3e-8fa2-0be4b6bc1849");
    protected final Creeper swellingCreeper;
    private LivingEntity creeperAttackTarget;
    private boolean walkingFuse = false;
    private boolean isBreaching = false;
    private float explosionSize;
    private float explosionSizeSqr;
    private final double IGNITE_DISTANCE_MULTIPLIER_SQR = 1.8225000000000002;
    @Nullable
    BetaStrafe betaStrafe;
    private Vec3 lastPosition = null;
    private int lastPositionTickstamp = 0;

    public EAICreeperSwellGoal(Creeper creeper) {
        this.swellingCreeper = creeper;
    }

    public boolean m_8036_() {
        if (this.explosionSize == 0.0f) {
            this.explosionSize = CreeperUtils.getExplosionSize(this.swellingCreeper);
            this.explosionSizeSqr = this.explosionSize * this.explosionSize;
        }
        this.creeperAttackTarget = this.swellingCreeper.m_5448_();
        if (this.creeperAttackTarget == null) {
            return false;
        }
        this.isBreaching = CreeperSwell.BREACH.get((Entity)this.swellingCreeper) != false && this.canBreach(this.creeperAttackTarget);
        return this.swellingCreeper.m_32310_() > 0 || this.isBreaching || (this.swellingCreeper.m_21574_().m_148306_((Entity)this.creeperAttackTarget) || CreeperSwell.IGNORE_WALLS.get((Entity)this.swellingCreeper) != false) && this.swellingCreeper.m_20280_((Entity)this.creeperAttackTarget) < (double)this.explosionSizeSqr * 1.8225000000000002;
    }

    public void m_8056_() {
        if (this.walkingFuse && this.betaStrafe == null) {
            MCUtils.applyModifier((LivingEntity)this.swellingCreeper, (Attribute)Attributes.f_22279_, (UUID)WALKING_FUSE_SPEED_MODIFIER_UUID, (String)"Walking fuse speed modifier", (double)CreeperSwell.WALKING_FUSE_SPEED_MODIFIER.get((Entity)this.swellingCreeper), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        } else {
            this.swellingCreeper.m_21573_().m_26573_();
        }
        this.swellingCreeper.m_32283_(1);
        this.swellingCreeper.m_21391_((Entity)this.creeperAttackTarget, 30.0f, 30.0f);
        if (this.betaStrafe != null) {
            this.betaStrafe.start();
        }
        this.explosionSize = CreeperUtils.getExplosionSize(this.swellingCreeper);
        this.explosionSizeSqr = this.explosionSize * this.explosionSize;
        if (CreeperSwell.insaneSurvivalOverhaulIntegration.booleanValue()) {
            this.swellingCreeper.getPersistentData().m_128350_("iguanatweaksreborn:explosion_ray_strength_multiplier", this.isBreaching ? 0.01f : 0.3f);
        }
    }

    public void m_8041_() {
        this.creeperAttackTarget = null;
        this.isBreaching = false;
        this.swellingCreeper.m_32283_(-1);
        AttributeInstance movementSpeed = this.swellingCreeper.m_21051_(Attributes.f_22279_);
        if (movementSpeed != null) {
            movementSpeed.m_22120_(WALKING_FUSE_SPEED_MODIFIER_UUID);
        }
    }

    public void m_8037_() {
        if (this.creeperAttackTarget == null || !this.creeperAttackTarget.m_6084_()) {
            this.tryCancelSwell();
        } else if (this.swellingCreeper.m_20280_((Entity)this.creeperAttackTarget) > (double)this.explosionSizeSqr * 2.0 * 2.0 && !this.isBreaching) {
            this.tryCancelSwell();
        } else if (!(this.swellingCreeper.m_21574_().m_148306_((Entity)this.creeperAttackTarget) || CreeperSwell.IGNORE_WALLS.get((Entity)this.swellingCreeper).booleanValue() || this.isBreaching)) {
            this.tryCancelSwell();
        } else {
            if (this.swellingCreeper.f_19797_ % 5 == 0) {
                this.swellingCreeper.m_32283_(1);
                this.alertNearby();
            }
            this.swellingCreeper.m_21391_((Entity)this.creeperAttackTarget, 30.0f, 30.0f);
            if (this.betaStrafe != null) {
                this.betaStrafe.tick();
            }
        }
    }

    private void alertNearby() {
        List creaturesNearby = this.swellingCreeper.m_9236_().m_45976_(PathfinderMob.class, this.swellingCreeper.m_20191_().m_82400_((double)(this.explosionSize * 2.0f)));
        for (PathfinderMob creatureEntity : creaturesNearby) {
            if (creatureEntity == this.swellingCreeper || creatureEntity == this.swellingCreeper.m_20202_()) continue;
            creatureEntity.f_21345_.f_25345_.forEach(prioritizedGoal -> {
                Goal patt5119$temp = prioritizedGoal.m_26015_();
                if (patt5119$temp instanceof AvoidExplosionGoal) {
                    AvoidExplosionGoal avoidExplosionGoal = (AvoidExplosionGoal)patt5119$temp;
                    avoidExplosionGoal.runFrom((Entity)this.swellingCreeper, this.explosionSize);
                }
            });
        }
    }

    private void tryCancelSwell() {
        if (!CreeperSwell.FORCE_EXPLODE.get((Entity)this.swellingCreeper).booleanValue()) {
            this.swellingCreeper.m_32283_(-1);
        }
    }

    public void setWalkingFuse(boolean walkingFuse) {
        if (walkingFuse) {
            this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
        } else {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }
        this.walkingFuse = walkingFuse;
    }

    public void setBetaStrafe(boolean beta) {
        this.betaStrafe = beta ? new BetaStrafe((PathfinderMob)this.swellingCreeper, CreeperSwell.BETA_LEFT_STRAFE.get((Entity)this.swellingCreeper), 0.5) : null;
    }

    public boolean canBreach(LivingEntity target) {
        if (!CreeperSwell.BREACH.get((Entity)this.swellingCreeper).booleanValue()) {
            return false;
        }
        double yDistance = this.swellingCreeper.m_20186_() - target.m_20186_();
        double x = target.m_20185_() - this.swellingCreeper.m_20185_();
        double z = target.m_20189_() - this.swellingCreeper.m_20189_();
        double xzDistance = x * x + z * z;
        double horizontalRange = CreeperSwell.BREACH_HORIZONTAL_RANGE.get((Entity)this.swellingCreeper);
        return this.isStuck() && !this.swellingCreeper.m_21574_().m_148306_((Entity)target) && !this.swellingCreeper.m_20069_() && xzDistance < horizontalRange * horizontalRange && yDistance > (double)(-CreeperUtils.getExplosionSize(this.swellingCreeper) - 2.0f);
    }

    public static boolean canCreeperBreach(Creeper creeper, LivingEntity target) {
        Set availableGoals = creeper.f_21345_.m_148105_();
        return availableGoals.stream().filter(wrappedGoal -> wrappedGoal.m_26015_() instanceof EAICreeperSwellGoal).anyMatch(eaCreeperSwellGoal -> ((EAICreeperSwellGoal)eaCreeperSwellGoal.m_26015_()).canBreach(target));
    }

    public boolean isStuck() {
        if (this.swellingCreeper.m_5448_() == null) {
            return false;
        }
        if (this.lastPosition == null || this.swellingCreeper.m_20238_(this.lastPosition) > 1.0) {
            this.lastPosition = this.swellingCreeper.m_20182_();
            this.lastPositionTickstamp = this.swellingCreeper.f_19797_;
        }
        return this.swellingCreeper.m_21573_().m_26571_() || this.swellingCreeper.f_19797_ - this.lastPositionTickstamp >= 30;
    }

    public boolean m_183429_() {
        return true;
    }
}

