/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.ghast;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.ghast.GhastShootFireballGoal;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:ghast", description="Various changes to ghast shooting. Only ghast in enhancedai:ghast/change_shooting entity type tag are affected by this feature.")
public class GhastFeature
extends Feature {
    public static final TagKey<EntityType<?>> CHANGE_GHAST_SHOOT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("ghast/change_shoot"));
    @Config(min=1.0, max=300.0, description="How many ticks pass between shooting fireballs. Vanilla is 40")
    public static MinMax attackCooldown = new MinMax(40.0, 50.0);
    @Config(min=1.0, max=16.0, description="How many fireballs ghast shoot in rapid succession. Vanilla is 1")
    public static MinMax fireballsShot = new MinMax(1.0, 3.0);
    @Config(min=0.0, max=1.0, description="Chance for a Ghast to try and shoot the target even if can't see it. If enabled and the Ghast can't see the target, he will shoot 4 times as fast to breach.")
    public static Double shootWhenNotSeenChance = 0.3;
    public static EAIData<Integer> ATTACK_COOLDOWN;
    public static EAIData<Integer> FIREBALLS_SHOT;
    public static EAIData<Boolean> SHOOT_WHEN_NOT_SEEN;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        ATTACK_COOLDOWN = EAIData.ofInt(this.createDataKey("attack_cooldown"));
        FIREBALLS_SHOT = EAIData.ofInt(this.createDataKey("fireballs_shot"));
        SHOOT_WHEN_NOT_SEEN = EAIData.ofBool(this.createDataKey("shoot_when_not_seen"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Ghast ghast;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Ghast) || !(ghast = (Ghast)entity).m_6095_().m_204039_(CHANGE_GHAST_SHOOT)) {
            return;
        }
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        ghast.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof Ghast.GhastShootFireballGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)ghast.f_21345_).m_25363_(arg_0));
        ghast.f_21345_.m_25352_(4, (Goal)new GhastShootFireballGoal(ghast));
        ATTACK_COOLDOWN.applyIfAbsent((Mob)ghast, attackCooldown.getIntRandBetween(ghast.m_217043_()));
        FIREBALLS_SHOT.applyIfAbsent((Mob)ghast, fireballsShot.getIntRandBetween(ghast.m_217043_()));
        SHOOT_WHEN_NOT_SEEN.applyIfAbsent((Mob)ghast, ghast.m_217043_().m_188500_() < shootWhenNotSeenChance);
    }
}

