/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Only entity types in the enhancedai:mobs/air_stealer tag are affected by this feature.")
public class AirSteal
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/air_stealer"));
    @Config(min=0.0, max=128.0, description="How many ticks of air are stolen from entities when attacked by the mob.")
    public static Integer stolenTicks = 40;
    public static EAIData<Integer> STOLEN_TICKS;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        STOLEN_TICKS = EAIData.ofInt(this.createDataKey("stolen_ticks"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        STOLEN_TICKS.applyIfAbsent(mob, stolenTicks);
    }

    @SubscribeEvent
    public void onAttack(LivingHurtEvent event) {
        LivingEntity attacker;
        Entity entity;
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || !((entity = event.getSource().m_7639_()) instanceof LivingEntity) || STOLEN_TICKS.get((Entity)(attacker = (LivingEntity)entity)) <= 0) {
            return;
        }
        event.getEntity().m_20301_(event.getEntity().m_20146_() - STOLEN_TICKS.get((Entity)attacker));
    }
}

