/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Mobs can bite if are attacked with non-weapons. Only mobs in the enhancedai:mobs/biting_mobs/can_bite entity type tag can bite. Entity types in `mobs/biting_mobs/unaffected_by_bite` tag are unaffected by bites. Damage types in `biting_mobs/doesnt_trigger_bite` tag don't trigger biting mobs.")
public class BitingMobs
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BITE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/biting_mobs/can_bite"));
    public static final TagKey<EntityType<?>> UNAFFECTED_BY_BITE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/biting_mobs/unaffected_by_bite"));
    public static final TagKey<DamageType> DOESNT_TRIGGER_BITE = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)EnhancedAI.location("doesnt_trigger_bite"));
    ResourceKey<DamageType> BITE_DAMAGE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)EnhancedAI.location("bite"));
    @Config(min=0.0, max=1.0, description="Chance for a Mob to bite the attacker")
    public static Difficulty chance = new Difficulty(0.2, 0.2, 0.3);
    @Config(min=0.0, description="The damage dealt to the attacker when bit")
    public static Double damage = 3.0;
    public static EAIData<Double> CHANCE;
    public static EAIData<Double> DAMAGE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CHANCE = EAIData.ofDouble(this.createDataKey("chance"));
        DAMAGE = EAIData.ofDouble(this.createDataKey("damage"));
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingDamageEvent event) {
        LivingEntity attacker;
        Mob mob;
        block6: {
            block5: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || !((livingEntity = event.getEntity()) instanceof Mob)) break block5;
                mob = (Mob)livingEntity;
                if (!event.getSource().m_269533_(DOESNT_TRIGGER_BITE) && mob.m_6095_().m_204039_(CAN_BITE) && mob.m_21051_(Attributes.f_22281_) != null && (livingEntity = event.getSource().m_7640_()) instanceof LivingEntity && !(attacker = livingEntity).m_6095_().m_204039_(UNAFFECTED_BY_BITE) && !attacker.m_21205_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_)) break block6;
            }
            return;
        }
        if (mob.m_217043_().m_188500_() < CHANCE.get((Entity)mob)) {
            DamageSource damageSource = mob.m_269291_().m_269298_(this.BITE_DAMAGE_TYPE, (Entity)mob);
            if (attacker.m_6673_(damageSource)) {
                return;
            }
            attacker.m_6469_(damageSource, DAMAGE.get((Entity)mob).floatValue());
        }
    }

    @SubscribeEvent
    public void onJoinLevelEvent(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_BITE)) {
            return;
        }
        CHANCE.applyIfAbsent(mob, chance.getByDifficulty(mob.m_9236_()));
        DAMAGE.applyIfAbsent(mob, damage);
    }
}

