/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import java.util.EnumSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs be able to jump in place when their target is a few blocks above them. Only entity types in the `enhancedai:mobs/can_jump_in_place` tag can jump")
public class Jump
extends Feature {
    public static final TagKey<EntityType<?>> CAN_JUMP = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_jump_in_place"));
    public static EAIData<Boolean> CAN_JUMP_DATA;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CAN_JUMP_DATA = EAIData.ofBool(this.createDataKey("can_jump"), (mob, canJump) -> {
            GoalHelper.removeGoal(mob.f_21345_, JumpGoal.class);
            if (canJump.booleanValue()) {
                mob.f_21345_.m_25352_(1, (Goal)new JumpGoal((Mob)mob));
            }
        });
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_JUMP)) {
            return;
        }
        CAN_JUMP_DATA.applyIfAbsent(mob, true);
    }

    public static class JumpGoal
    extends Goal {
        protected LivingEntity target;
        protected Mob goalOwner;
        protected int ticksWithoutPath;

        public JumpGoal(Mob goalOwner) {
            this.goalOwner = goalOwner;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (!this.goalOwner.m_20096_()) {
                return false;
            }
            this.target = this.goalOwner.m_5448_();
            if (this.target == null) {
                return false;
            }
            if (this.goalOwner.m_21573_().m_26571_() || this.goalOwner.m_21573_().m_26577_()) {
                ++this.ticksWithoutPath;
            } else {
                this.ticksWithoutPath = 0;
                return false;
            }
            double yDistance = this.target.m_20186_() - this.goalOwner.m_20186_();
            double x = this.target.m_20185_() - this.goalOwner.m_20185_();
            double z = this.target.m_20189_() - this.goalOwner.m_20189_();
            double xzDistance = x * x + z * z;
            MobEffectInstance jumpBoost = this.goalOwner.m_21124_(MobEffects.f_19603_);
            double bonusJumpBoost = 0.0;
            if (jumpBoost != null) {
                bonusJumpBoost = (float)(jumpBoost.m_19564_() + 1) * 0.75f;
            }
            return xzDistance < 8.0 && yDistance > 0.0 && yDistance <= 1.0 + bonusJumpBoost + (double)Mth.m_14167_((float)this.goalOwner.m_20206_()) && this.ticksWithoutPath > this.m_183277_(25);
        }

        public void m_8041_() {
            this.ticksWithoutPath = 0;
        }

        public void m_8056_() {
            this.goalOwner.m_21569_().m_24901_();
            this.m_8041_();
        }
    }
}

