/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;

@LoadFeature(module="enhancedai:mobs", description="Changes mobs attack range to use the 1.20.2 mechanic")
public class MeleeAttacking
extends Feature {
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    @Config(description="If true melee monsters (zombies, etc) will attack like 1.20.2+ and the attack range is based off the forge:entity_reach attribute (default 0.82 blocks).")
    public static Boolean attackReachAttributeBased = true;
    @Config(description="If true melee monsters (zombies, etc) attack speed is 4 (like the player) and will be based off the `minecraft:generic.attack_speed` attribute.")
    public static Boolean attackSpeed$attributeBased = true;
    @Config(min=0.0, max=4.0, description="Multiplies the attack speed of monsters by this value.")
    public static Difficulty attackSpeed$multiplier = new Difficulty(0.25, 0.25, 0.25);
    @Config(min=0.0, max=4.0, description="The maximum attack speed a mob can attack with (in attacks per second, 2 is an attack every 0.5 seconds, 1.25 is an attack every 0.8s, 1 is an attack every 1s).")
    public static Double attackSpeed$maximum = 4.0;

    public static void attributeModificationEvent(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (!event.has(entityType, (Attribute)ForgeMod.ENTITY_REACH.get())) {
                event.add(entityType, (Attribute)ForgeMod.ENTITY_REACH.get(), DEFAULT_ATTACK_REACH);
            }
            if (event.has(entityType, Attributes.f_22283_)) continue;
            event.add(entityType, Attributes.f_22283_, 4.0);
        }
    }

    public static Boolean shouldChangeAttackReach() {
        return MeleeAttacking.isEnabled(MeleeAttacking.class) && attackReachAttributeBased != false;
    }

    public static Boolean shouldUseAttackSpeedAttribute() {
        return MeleeAttacking.isEnabled(MeleeAttacking.class) && attackSpeed$attributeBased != false;
    }

    public static boolean isWithinMeleeAttackRange(LivingEntity attacker, LivingEntity attacked) {
        return MeleeAttacking.getAttackBoundingBox(attacker).m_82381_(MeleeAttacking.getHitbox(attacked));
    }

    protected static AABB getAttackBoundingBox(LivingEntity attacker) {
        AABB aabb;
        Entity entity = attacker.m_20202_();
        if (entity != null) {
            AABB veichleAABB = entity.m_20191_();
            AABB attackerAABB = attacker.m_20191_();
            aabb = new AABB(Math.min(attackerAABB.f_82288_, veichleAABB.f_82288_), attackerAABB.f_82289_, Math.min(attackerAABB.f_82290_, veichleAABB.f_82290_), Math.max(attackerAABB.f_82291_, veichleAABB.f_82291_), attackerAABB.f_82292_, Math.max(attackerAABB.f_82293_, veichleAABB.f_82293_));
        } else {
            aabb = attacker.m_20191_();
        }
        double attackReach = DEFAULT_ATTACK_REACH;
        if (MeleeAttacking.shouldChangeAttackReach().booleanValue()) {
            attackReach = attacker.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        }
        return aabb.m_82377_(attackReach, 0.0, attackReach);
    }

    protected static AABB getHitbox(LivingEntity entity) {
        AABB aabb = entity.m_20191_();
        Entity vehicle = entity.m_20202_();
        if (vehicle != null) {
            Vec3 vec3 = new Vec3(entity.m_20185_(), vehicle.m_6048_(), entity.m_20186_());
            return aabb.m_165887_(Math.max(vec3.f_82480_, aabb.f_82289_));
        }
        return aabb;
    }
}

