/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.anticheese;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.anticheese.BreakVehicleGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", name="Anti-Cheese", description="Prevent players from abusing some game mechanics to stop mobs, like vehicles or 2 block tall holes for endermen.")
public class VehicleAntiCheese
extends Feature {
    public static final TagKey<EntityType<?>> PREVENT_VEHICLE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/vehicle_anti_cheese/prevent_riding"));
    public static final TagKey<EntityType<?>> CAN_BREAK_VEHICLE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/vehicle_anti_cheese/break_vehicle"));
    public static final TagKey<EntityType<?>> VALID_VEHICLES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/vehicle_anti_cheese/valid_vehicles"));
    @Config(description="If true, entity types in the enhancedai:vehicle_anti_cheese/prevent_riding tag will not be able to mount vehicles in `enhancedai:mobs/vehicle_anti_cheese/valid_vehicles`.")
    public static Boolean preventRidingVehicles = false;
    @Config(description="If true, entity types in the enhancedai:mobs/vehicle_anti_cheese/break_vehicle tag will get an AI to break vehicles in `enhancedai:mobs/vehicle_anti_cheese/valid_vehicles` tag.")
    public static Boolean breakVehicles = true;
    public static EAIData<Boolean> PREVENT_RIDING;
    public static EAIData<Boolean> BREAK_VEHICLE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        PREVENT_RIDING = EAIData.ofBool(this.createDataKey("prevent_riding"));
        BREAK_VEHICLE = EAIData.ofBool(this.createDataKey("break_vehicle"), (mob, canBreakVehicle) -> {
            GoalHelper.removeGoal(mob.f_21345_, BreakVehicleGoal.class);
            if (canBreakVehicle.booleanValue()) {
                mob.f_21345_.m_25352_(1, (Goal)new BreakVehicleGoal((Mob)mob));
            }
        });
    }

    @SubscribeEvent
    public void onMount(EntityMountEvent event) {
        if (!(this.isEnabled() && event.getEntityBeingMounted().m_6095_().m_204039_(VALID_VEHICLES) && PREVENT_RIDING.get(event.getEntity()).booleanValue())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (mob.m_6095_().m_204039_(CAN_BREAK_VEHICLE)) {
            BREAK_VEHICLE.applyIfAbsent(mob, breakVehicles);
        }
        if (mob.m_6095_().m_204039_(PREVENT_VEHICLE)) {
            PREVENT_RIDING.applyIfAbsent(mob, preventRidingVehicles);
        }
    }
}

