/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.avoidexplosion;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.avoidexplosion.AvoidExplosionGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Mobs will run away from exploding creepers / TNT. Only entity types in `enhancedai:mobs/can_run_from_explosions` tag will be affected by this feature")
public class AvoidExplosions
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_run_from_explosions"));
    @Config(min=0.0, max=1.0, description="Chance for a mob to be able to run from explosions.")
    public static Double chance = 0.8;
    @Config(min=0.0, max=10.0, description="Speed multiplier when the mob runs from explosions and it's within 7 blocks from him.")
    public static Double runSpeedNear = 1.1;
    @Config(min=0.0, max=10.0, description="Speed multiplier when the mob runs from explosions and it's farther than 7 blocks from him.")
    public static Double runSpeedFar = 1.0;
    @Config(min=0.0, max=10.0, description="Entities also flee from TnTs")
    public static Boolean fleeTnt = true;
    public static EAIData<Boolean> CAN_RUN_FROM_EXPLOSIONS;
    public static EAIData<Boolean> CAN_RUN_FROM_TNT;
    public static EAIData<Double> FLEE_SPEED_FAR;
    public static EAIData<Double> FLEE_SPEED_NEAR;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CAN_RUN_FROM_EXPLOSIONS = EAIData.ofBool(this.createDataKey("can_run_from_explosions"), (mob, canRun) -> {
            if (!(mob instanceof PathfinderMob)) {
                return;
            }
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            GoalHelper.removeGoal(mob.f_21345_, AvoidExplosionGoal.class);
            if (canRun.booleanValue()) {
                mob.f_21345_.m_25352_(1, (Goal)new AvoidExplosionGoal(pathfinderMob, FLEE_SPEED_FAR, FLEE_SPEED_NEAR));
            }
        });
        CAN_RUN_FROM_TNT = EAIData.ofBool(this.createDataKey("can_run_from_tnt"));
        FLEE_SPEED_FAR = EAIData.ofDouble(this.createDataKey("flee_speed_far"));
        FLEE_SPEED_NEAR = EAIData.ofDouble(this.createDataKey("flee_speed_near"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        PathfinderMob mob;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity())) {
            return;
        }
        this.alertTNT(event.getEntity());
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob && (mob = (PathfinderMob)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            CAN_RUN_FROM_EXPLOSIONS.applyIfAbsent((Mob)mob, mob.m_217043_().m_188500_() < chance);
            FLEE_SPEED_FAR.applyIfAbsent((Mob)mob, runSpeedFar);
            FLEE_SPEED_NEAR.applyIfAbsent((Mob)mob, runSpeedNear);
            CAN_RUN_FROM_TNT.applyIfAbsent((Mob)mob, fleeTnt);
        }
    }

    private void alertTNT(Entity entity) {
        if (entity.m_6095_() != EntityType.f_20515_) {
            return;
        }
        List pathfinderMobs = entity.m_9236_().m_45976_(PathfinderMob.class, entity.m_20191_().m_82400_(8.0));
        for (PathfinderMob pathfinderMob : pathfinderMobs) {
            if (!CAN_RUN_FROM_TNT.get((Entity)pathfinderMob).booleanValue() || !pathfinderMob.m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) continue;
            GoalHelper.getGoal(pathfinderMob.f_21345_, AvoidExplosionGoal.class).ifPresent(goal -> goal.runFrom(entity, 8.0));
        }
    }
}

