/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.parkour;

import insane96mcp.enhancedai.ai.EAIRangedAttackGoal;
import insane96mcp.enhancedai.modules.illager.shoot.EAIPillagerAttackGoal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.phys.Vec3;

public class ParkourGoal
extends Goal {
    protected LivingEntity target;
    protected Mob goalOwner;
    private int jumpBlocks = 0;
    private Vec3 lastPosition = null;
    private int lastPositionTickstamp = Integer.MAX_VALUE;
    private boolean waitForLanding = false;
    private static final int MAX_FORWARD_BLOCK_CHECK = 3;
    private static final double FORWARD_STEP_EPSILON = 0.1;
    private static final double SLIGHT_DOWNWARD_NUDGE = -0.01;

    public ParkourGoal(Mob goalOwner) {
        this.goalOwner = goalOwner;
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (!this.goalOwner.m_20096_() || this.goalOwner.m_20159_() || this.hasConflictingRunningGoals()) {
            this.resetLastPosition();
            return false;
        }
        this.target = this.goalOwner.m_5448_();
        if (this.target == null || !this.goalOwner.m_142582_((Entity)this.target)) {
            this.resetLastPosition();
            return false;
        }
        if (!this.isStuck()) {
            return false;
        }
        Vec3 toTargetDir = new Vec3(this.target.m_20185_() - this.goalOwner.m_20185_(), this.target.m_20186_() - this.goalOwner.m_20186_(), this.target.m_20189_() - this.goalOwner.m_20189_()).m_82541_();
        this.jumpBlocks = this.findJumpBlocksTowardsTarget(toTargetDir);
        return this.jumpBlocks > 0;
    }

    private boolean hasConflictingRunningGoals() {
        return this.goalOwner.f_21345_.m_25386_().anyMatch(wrappedGoal -> this.isConflictingGoal(wrappedGoal.m_26015_()));
    }

    private boolean isConflictingGoal(Goal goal) {
        return goal instanceof RangedAttackGoal || goal instanceof EAIRangedAttackGoal || goal instanceof EAIPillagerAttackGoal;
    }

    private int findJumpBlocksTowardsTarget(Vec3 toTargetDir) {
        for (int offsetBlocks = 1; offsetBlocks <= 3; ++offsetBlocks) {
            Vec3 probe = this.goalOwner.m_20182_().m_82549_(toTargetDir.m_82490_((double)offsetBlocks + 0.1)).m_82520_(0.0, -0.01, 0.0);
            BlockPos candidatePos = BlockPos.m_274446_((Position)probe);
            if (!this.goalOwner.m_9236_().m_8055_(candidatePos).m_280296_()) continue;
            return offsetBlocks;
        }
        return 0;
    }

    public boolean m_8045_() {
        return this.waitForLanding && !this.goalOwner.m_20096_();
    }

    public void m_8041_() {
        this.resetLastPosition();
        this.jumpBlocks = 0;
        this.waitForLanding = false;
        this.goalOwner.m_21573_().m_26573_();
        if (this.target != null && !this.target.m_21224_() && !this.target.m_213877_()) {
            this.goalOwner.m_21573_().m_5624_((Entity)this.target, 1.0);
        }
    }

    public void m_8056_() {
        this.goalOwner.m_21569_().m_24901_();
        double distanceY = this.target.m_20186_() - this.goalOwner.m_20186_();
        double distanceX = this.target.m_20185_() - this.goalOwner.m_20185_();
        double distanceZ = this.target.m_20189_() - this.goalOwner.m_20189_();
        double factor = 0.65 - (double)(3 - this.jumpBlocks) * 0.2;
        this.goalOwner.m_20256_(this.goalOwner.m_20184_().m_82549_(new Vec3(distanceX, distanceY, distanceZ).m_82541_()).m_82542_(factor, 1.0, factor));
        this.waitForLanding = true;
    }

    public boolean isStuck() {
        if (this.goalOwner.m_5448_() == null || this.goalOwner.m_20280_((Entity)this.goalOwner.m_5448_()) < 1.0) {
            this.resetLastPosition();
            return false;
        }
        if (this.lastPosition == null || this.goalOwner.m_20238_(this.lastPosition) > 0.36) {
            this.lastPosition = this.goalOwner.m_20182_();
            this.lastPositionTickstamp = this.goalOwner.f_19797_;
        }
        return this.goalOwner.f_19797_ - this.lastPositionTickstamp >= this.m_183277_(40);
    }

    public void resetLastPosition() {
        this.lastPosition = null;
        this.lastPositionTickstamp = Integer.MAX_VALUE;
    }
}

