/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.pickandthrow;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.pickandthrow.PickUpAndThrowGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs pick up and throw other mobs. Mobs in the `enhancedai:mobs/pick_up_and_throw/can_be_picked_up` tag will be able to be picked up, while mobs in the `enhancedai:mobs/pick_up_and_throw/can_pick_up` tag will be able to pick up other mobs.")
public class PickUpAndThrow
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_PICKED_UP = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/pick_up_and_throw/can_be_picked_up"));
    public static final TagKey<EntityType<?>> CAN_PICK_UP = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/pick_up_and_throw/can_pick_up"));
    @Config(min=0.0, max=1.0, description="Chance for a mob to have an AI to go and pick up and throw mobs.")
    public static Difficulty chance = new Difficulty(0.05, 0.05, 0.1);
    @Config(min=0.0, description="Min distance from the target to let the mob pick up a mob")
    public static Integer minDistanceToPickUp = 5;
    @Config(min=0.0, description="Max distance beyond which the mob will not throw the picked up mob")
    public static Integer maxDistanceToThrow = 24;
    @Config(min=0.0, description="Speed modifier to apply to the mob when it picks up another mob")
    public static Double speedModifierToPickUp = 1.25;
    @Config(min=0.0, description="Cooldown (in ticks) after throwing a mob. Also goes on cooldown if can't reach the targeted mob for a few seconds")
    public static Integer cooldown = 600;
    public static EAIData<String> CAN_PICK_UP_DATA;
    public static EAIData<Integer> MIN_DISTANCE_TO_PICK_UP;
    public static EAIData<Integer> MAX_DISTANCE_TO_THROW;
    public static EAIData<Double> SPEED_MODIFIER_TO_PICK_UP;
    public static EAIData<Integer> COOLDOWN;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CAN_PICK_UP_DATA = EAIData.ofString(this.createDataKey("can_pick_up"));
        MIN_DISTANCE_TO_PICK_UP = EAIData.ofInt(this.createDataKey("min_distance_to_pick_up"));
        MAX_DISTANCE_TO_THROW = EAIData.ofInt(this.createDataKey("max_distance_to_throw"));
        SPEED_MODIFIER_TO_PICK_UP = EAIData.ofDouble(this.createDataKey("speed_modifier_to_pick_up"));
        COOLDOWN = EAIData.ofInt(this.createDataKey("cooldown"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_PICK_UP) || mob.m_6162_()) {
            return;
        }
        if (mob.m_217043_().m_188500_() < chance.getByDifficulty(mob.m_9236_())) {
            CAN_PICK_UP_DATA.applyIfAbsent(mob, CAN_BE_PICKED_UP.f_203868_().toString());
        } else {
            CAN_PICK_UP_DATA.applyIfAbsent(mob, "");
        }
        MIN_DISTANCE_TO_PICK_UP.applyIfAbsent(mob, minDistanceToPickUp);
        MAX_DISTANCE_TO_THROW.applyIfAbsent(mob, maxDistanceToThrow);
        SPEED_MODIFIER_TO_PICK_UP.applyIfAbsent(mob, speedModifierToPickUp);
        COOLDOWN.applyIfAbsent(mob, cooldown);
        mob.f_21346_.m_25352_(0, (Goal)new PickUpAndThrowGoal(mob));
    }
}

