/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.villager;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAIHurtByTargetGoal;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.mixin.accessors.MeleeAttackGoalAccessor;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:villager", description="Make villagers fight back. Use the enhancedai:villager/can_attack type tag to add more villagers, only works with entities that extend vanilla Villagers. Attack damage can't be changed via config due to limitation so use mods like Mobs Properties Randomness to change the damage. Base damage is 4.")
public class VillagerAttacking
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("villager/can_attack"));
    @Config(description="If true, villagers will attack back monsters")
    public static Boolean villagersFightBackEnemies = false;
    @Config(description="Villagers will only attack players that have below this reputation (like Iron Golems by default). https://minecraft.wiki/w/Villager#Gossiping")
    public static Integer minReputationFightBack = -100;
    @Config(min=0.0, max=4.0, description="Movement speed multiplier when attacking")
    public static Double speedMultiplier = 0.4;
    public static EAIData<Boolean> FIGHTS_BACK_ENEMIES;
    public static EAIData<Integer> ATTACK_BELOW_REPUTATION;
    public static EAIData<Double> SPEED_MULTIPLIER;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        FIGHTS_BACK_ENEMIES = EAIData.ofBool(this.createDataKey("fights_back_enemies"));
        ATTACK_BELOW_REPUTATION = EAIData.ofInt(this.createDataKey("attack_below_reputation"));
        SPEED_MULTIPLIER = EAIData.ofDouble(this.createDataKey("speed_multiplier"), (mob, speedMultiplier) -> {
            if (!mob.m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
                return;
            }
            GoalHelper.getGoal(mob.f_21345_, MeleeAttackGoal.class).ifPresent(attackGoal -> ((MeleeAttackGoalAccessor)attackGoal).setSpeedModifier((double)speedMultiplier));
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Villager villager;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Villager) || !(villager = (Villager)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        villager.f_21346_.m_25352_(1, (Goal)new EAIVillagerHurtByTargetGoal(villager, new Class[0]).setAlertOthers(new Class[0]));
        villager.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)villager, 1.0, false));
        FIGHTS_BACK_ENEMIES.applyIfAbsent((Mob)villager, villagersFightBackEnemies);
        ATTACK_BELOW_REPUTATION.applyIfAbsent((Mob)villager, minReputationFightBack);
        SPEED_MULTIPLIER.applyIfAbsent((Mob)villager, speedMultiplier);
    }

    public static class EAIVillagerHurtByTargetGoal
    extends EAIHurtByTargetGoal {
        Villager villager;

        public EAIVillagerHurtByTargetGoal(Villager villager, Class<?> ... toIgnoreDamage) {
            super((Mob)villager, toIgnoreDamage);
            this.villager = villager;
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            LivingEntity hurtVillager = this.f_26135_.m_21188_();
            if (hurtVillager instanceof Player) {
                Player player = (Player)hurtVillager;
                return this.villager.m_35532_(player) <= ATTACK_BELOW_REPUTATION.get((Entity)this.villager);
            }
            if (hurtVillager instanceof Enemy) {
                return FIGHTS_BACK_ENEMIES.get((Entity)this.villager);
            }
            return true;
        }
    }
}

