/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.data;

import insane96mcp.enhancedai.utils.LogHelper;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionOrMobEffect {
    Potion potion;
    MobEffectInstance mobEffectInstance;

    public PotionOrMobEffect(Potion potion) {
        this.potion = potion;
    }

    public PotionOrMobEffect(MobEffectInstance mobEffectInstance) {
        this.mobEffectInstance = mobEffectInstance;
    }

    public ItemStack getPotionStack() {
        return this.getStackInternal(Items.f_42589_);
    }

    public ItemStack getSplashPotionStack() {
        return this.getStackInternal(Items.f_42736_);
    }

    public ItemStack getLingeringPotionStack() {
        return this.getStackInternal(Items.f_42739_);
    }

    private ItemStack getStackInternal(Item item) {
        ItemStack stack = this.potion != null ? PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)this.potion) : MCUtils.setCustomEffects((ItemStack)new ItemStack((ItemLike)item), List.of(new MobEffectInstance(this.mobEffectInstance)));
        return stack;
    }

    public List<MobEffect> getMobEffects() {
        ArrayList<MobEffect> mobEffects = new ArrayList<MobEffect>();
        if (this.potion != null) {
            for (MobEffectInstance mobEffectInstance1 : this.potion.m_43488_()) {
                mobEffects.add(mobEffectInstance1.m_19544_());
            }
        } else {
            mobEffects.add(this.mobEffectInstance.m_19544_());
        }
        return mobEffects;
    }

    public boolean hasMobEffect(LivingEntity living) {
        List<MobEffect> mobEffects = this.getMobEffects();
        for (MobEffectInstance mobEffect : living.m_21220_()) {
            if (!mobEffects.contains(mobEffect.m_19544_())) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<PotionOrMobEffect> parseList(List<? extends String> list) {
        ArrayList<PotionOrMobEffect> potionOrMobEffects = new ArrayList<PotionOrMobEffect>();
        for (String string : list) {
            Potion potion = PotionOrMobEffect.parsePotion(string);
            if (potion != null) {
                potionOrMobEffects.add(new PotionOrMobEffect(potion));
                continue;
            }
            MobEffectInstance mobEffectInstance = MCUtils.parseEffectInstance((String)string);
            if (mobEffectInstance != null) {
                potionOrMobEffects.add(new PotionOrMobEffect(mobEffectInstance));
                continue;
            }
            LogHelper.warn("%s is not a valid potion or a mob effect instance", string);
        }
        return potionOrMobEffects;
    }

    @Nullable
    public static Potion parsePotion(String s) {
        ResourceLocation effectRL = ResourceLocation.m_135820_((String)s);
        if (effectRL == null) {
            return null;
        }
        return (Potion)ForgeRegistries.POTIONS.getValue(effectRL);
    }

    public Potion getPotion() {
        return this.potion;
    }
}

