/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.bugs.silverfish.wakeupfriends;

import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.bugs.silverfish.wakeupfriends.EAISilverfishWakeUpFriendsGoal;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:bugs", description="Let them swarm.")
public class SilverfishWakeUpFriends
extends Feature {
    @Config(min=0.0, description="Vanilla is 20.")
    public static Integer ticksAfterHurtToWakeUpFriends = 10;
    @Config(min=1.0, description="In vanilla everytime a silverfish is woken up there is 1 in 2 chance to stop waking up more silverfish. This changes the 1 in x chance.")
    public static Integer chanceToStopWakingUpFriends = 5;
    @Config(min=1.0, max=32.0, description="Y range on which a hurt silverfish checks for infested stone to break. Vanilla is 5.")
    public static Integer verticalWakeUpRange = 5;
    @Config(min=1.0, max=32.0, description="XZ range on which a hurt silverfish checks for infested stone to break. Vanilla is 10.")
    public static Integer horizontalWakeUpRange = 10;
    public static EAIData<Integer> TICKS_AFTER_HURT_TO_WAKE_UP_FRIENDS;
    public static EAIData<Integer> CHANCE_TO_STOP_WAKING_UP_FRIENDS;
    public static EAIData<Integer> VERTICAL_WAKE_UP_RANGE;
    public static EAIData<Integer> HORIZONTAL_WAKE_UP_RANGE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        TICKS_AFTER_HURT_TO_WAKE_UP_FRIENDS = EAIData.ofInt(this.createDataKey("ticks_after_hurt_to_wake_up_friends"));
        CHANCE_TO_STOP_WAKING_UP_FRIENDS = EAIData.ofInt(this.createDataKey("chance_to_stop_waking_up_friends"));
        VERTICAL_WAKE_UP_RANGE = EAIData.ofInt(this.createDataKey("vertical_wake_up_range"));
        HORIZONTAL_WAKE_UP_RANGE = EAIData.ofInt(this.createDataKey("horizontal_wake_up_range"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Silverfish)) {
            return;
        }
        Silverfish silverfish = (Silverfish)entity;
        GoalHelper.removeGoal(silverfish.f_21345_, Silverfish.SilverfishWakeUpFriendsGoal.class);
        silverfish.f_33521_ = new EAISilverfishWakeUpFriendsGoal(silverfish);
        silverfish.f_21345_.m_25352_(3, (Goal)silverfish.f_33521_);
        TICKS_AFTER_HURT_TO_WAKE_UP_FRIENDS.applyIfAbsent((Mob)silverfish, ticksAfterHurtToWakeUpFriends);
        CHANCE_TO_STOP_WAKING_UP_FRIENDS.applyIfAbsent((Mob)silverfish, chanceToStopWakingUpFriends);
        VERTICAL_WAKE_UP_RANGE.applyIfAbsent((Mob)silverfish, verticalWakeUpRange);
        HORIZONTAL_WAKE_UP_RANGE.applyIfAbsent((Mob)silverfish, horizontalWakeUpRange);
    }
}

