/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper.launch;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.creeper.launch.EAICreeperLaunchGoal;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.network.message.MessageCreeperDataSync;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:creeper", description="Creepers can ignite and throw themselves at players. Only entity types in the enhancedai:creeper/can_launch tag will be affected by this feature.")
public class CreeperLaunch
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("creeper/can_launch"));
    @Config(min=0.0, max=1.0, description="Launching creepers will try ignite and throw themselves at the player. Only creepers in the enhancedai:creeper/can_launch")
    public static Double chance = 0.05;
    @Config(description="If true, Launching Creepers emit particles")
    public static Boolean particles = true;
    @Config(min=0.0, max=8.0, description="The inaccuracy of the launching creeper in Normal difficulty, easy is increased, hard is decreased.")
    public static Difficulty inaccuracy = new Difficulty(2.0, 2.0, 1.0);
    @Config(min=0.0, max=127.0, description="The explosion radius of launching creepers. Set to 0 to not change. (Overrides Cena creepers explosion radius)")
    public static Integer explosionRadius = 2;
    public static EAIData<Boolean> LAUNCH;
    public static EAIData<Double> INACCURACY;
    public static EAIData<Boolean> PARTICLES;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        LAUNCH = EAIData.ofBool(this.createDataKey("launch"), (mob, launch) -> {
            if (!(mob instanceof Creeper)) {
                return;
            }
            Creeper creeper = (Creeper)mob;
            boolean wasLaunch = GoalHelper.removeGoal(creeper.f_21345_, EAICreeperLaunchGoal.class).isPresent();
            CompoundTag compoundNBT = new CompoundTag();
            creeper.m_7380_(compoundNBT);
            if (launch.booleanValue()) {
                mob.f_21345_.m_25352_(1, (Goal)new EAICreeperLaunchGoal(creeper));
                if (explosionRadius > 0) {
                    compoundNBT.m_128344_("ExplosionRadius", explosionRadius.byteValue());
                }
            } else if (wasLaunch && explosionRadius > 0) {
                compoundNBT.m_128344_("ExplosionRadius", (byte)3);
            }
            creeper.m_7378_(compoundNBT);
            MessageCreeperDataSync.syncCreeperToPlayers((Creeper)creeper);
        });
        INACCURACY = EAIData.ofDouble(this.createDataKey("inaccuracy"));
        PARTICLES = EAIData.ofBool(this.createDataKey("particles"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void eventEntityJoinWorld(EntityJoinLevelEvent event) {
        Creeper creeper;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Creeper) || !(creeper = (Creeper)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        LAUNCH.applyIfAbsent((Mob)creeper, creeper.m_217043_().m_188500_() < chance);
        INACCURACY.applyIfAbsent((Mob)creeper, inaccuracy.getByDifficulty(creeper.m_9236_()));
        PARTICLES.applyIfAbsent((Mob)creeper, particles);
    }

    @SubscribeEvent
    public void onCreeperTick(LivingEvent.LivingTickEvent event) {
        ServerLevel serverLevel;
        Creeper creeper;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Creeper) || !((livingEntity = (creeper = (Creeper)livingEntity).m_9236_()) instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)livingEntity;
                if ((creeper.f_19797_ + creeper.m_19879_()) % 20 == 0 && LAUNCH.get((Entity)creeper).booleanValue() && PARTICLES.get((Entity)creeper).booleanValue()) break block3;
            }
            return;
        }
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, creeper.m_20185_(), creeper.m_20186_() + 0.25, creeper.m_20189_(), 8, 0.05, 0.05, 0.05, 0.025);
    }
}

