/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper.swell;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.creeper.swell.EAICreeperSwellGoal;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.setup.EAISounds;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.module.base.TagsFeature;
import insane96mcp.insanelib.network.message.MessageCreeperDataSync;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:creeper", description="Various changes to Creepers exploding. Ignoring Walls, Walking Fuse and smarter exploding based off explosion size. Only creepers in the enhancedai:creeper/change_swell entity type tag are affected by this feature.")
public class CreeperSwell
extends Feature {
    public static final TagKey<EntityType<?>> CHANGE_CREEPER_SWELL = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("creeper/change_swell"));
    @Config(min=0.0, max=1.0, description="Percentage chance for a Creeper to keep walking while exploding. This is overwritten if the creeper has the beta property.")
    public static Double walkingFuse$chance = 0.1;
    @Config(min=-1.0, max=64.0, description="Speed modifier when a walking fuse creeper is swelling.")
    public static Double walkingFuse$speedModifier = -0.5;
    @Config(min=0.0, max=1.0, description="Percentage chance for a Creeper to ignore walls while targeting a player. This means that a creeper will be able to explode if it's in the correct range from a player even if there's a wall between.")
    public static Double ignoreWallsChance = 0.65;
    @Config(min=0.0, max=1.0, description="Breaching creepers will try to open a hole in the wall to let mobs in.")
    public static Double breach$chance = 0.075;
    @Config(min=0.0, description="How far away (horizontally) from the target breaching creepers can breach.")
    public static Integer breach$horizontalRange = 24;
    @Config(min=0.0, max=1.0, description="Creepers with beta strafing will walk around the target, like the in pre-1.2. This takes precedence over walking fuse.")
    public static Double betaStrafe$chance = 0.35;
    @Config(min=0.0, max=1.0, description="Chance for a creeper to spawn angry")
    public static Double angry$chance = 0.03;
    @Config(description="If true, Angry Creeper emits particles")
    public static Boolean angry$particles = true;
    @Config(description="The special sound effect that the Angry Creeper plays")
    public static FuseExplodeSounds angry$sounds = FuseExplodeSounds.CENA;
    @Config(description="If true, Angry Creeper will have a name")
    public static Boolean angry$name = true;
    @Config(description="When ignited, Angry Creeper will not stop swelling")
    public static Boolean angry$forceExplosion = false;
    @Config(description="Makes angry creepers blow up on death like when they were added back in 0.30")
    public static Boolean angry$explodeOnDeath = true;
    @Config(description="If true, Angry Creeper explosion will generate fire")
    public static Boolean angry$fire = false;
    @Config(min=0.0, max=12.0, description="Explosion power of Angry Creeper")
    public static Double angry$explosionPower = 4.0;
    @Config(description="Makes creepers blow up on death like when they were added back in 0.30")
    public static BlowUpOnDeath blowUpOnDeath = BlowUpOnDeath.CHARGED;
    @Config(description="If Insane's Survival Overhaul is installed and Explosion Overhaul feature is enabled, Angry creeper will deal more knockback and break more blocks, breaching creepers will break more blocks")
    public static Boolean insaneSurvivalOverhaulIntegration = true;
    public static EAIData<Boolean> WALKING_FUSE;
    public static EAIData<Double> WALKING_FUSE_SPEED_MODIFIER;
    public static EAIData<Boolean> IGNORE_WALLS;
    public static EAIData<Boolean> BREACH;
    public static EAIData<Double> BREACH_HORIZONTAL_RANGE;
    public static EAIData<Boolean> BETA_STRAFE;
    public static EAIData<Boolean> BETA_LEFT_STRAFE;
    public static EAIData<Boolean> BLOW_UP_ON_DEATH;
    public static EAIData<Boolean> FORCE_EXPLODE;
    public static EAIData<Boolean> ANGRY;
    public static EAIData<String> EXPLOSION_SOUND;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        WALKING_FUSE = EAIData.ofBool(this.createDataKey("walking_fuse"), (mob, walkingFuse) -> GoalHelper.getGoal(mob.f_21345_, EAICreeperSwellGoal.class).ifPresent(eaCreeperSwellGoal -> eaCreeperSwellGoal.setWalkingFuse((boolean)walkingFuse)));
        WALKING_FUSE_SPEED_MODIFIER = EAIData.ofDouble(this.createDataKey("walking_fuse_speed_modifier"));
        IGNORE_WALLS = EAIData.ofBool(this.createDataKey("ignore_walls"));
        BREACH = EAIData.ofBool(this.createDataKey("breach"));
        BREACH_HORIZONTAL_RANGE = EAIData.ofDouble(this.createDataKey("breach_horizontal_range"));
        BETA_STRAFE = EAIData.ofBool(this.createDataKey("beta_strafe"), (mob, beta) -> GoalHelper.getGoal(mob.f_21345_, EAICreeperSwellGoal.class).ifPresent(eaCreeperSwellGoal -> eaCreeperSwellGoal.setBetaStrafe((boolean)beta)));
        BETA_LEFT_STRAFE = EAIData.ofBool(this.createDataKey("beta_left_strafe"));
        BLOW_UP_ON_DEATH = EAIData.ofBool(this.createDataKey("blow_up_on_death"));
        FORCE_EXPLODE = EAIData.ofBool(this.createDataKey("force_explode"));
        ANGRY = EAIData.ofBool(this.createDataKey("angry"), (mob, angry) -> {
            if (!(mob instanceof Creeper)) {
                return;
            }
            Creeper creeper = (Creeper)mob;
            CompoundTag compoundNBT = new CompoundTag();
            creeper.m_7380_(compoundNBT);
            if (angry.booleanValue()) {
                compoundNBT.m_128376_("Fuse", (short)36);
                compoundNBT.m_128344_("ExplosionRadius", angry$explosionPower.byteValue());
                if (angry$name.booleanValue()) {
                    creeper.m_6593_((Component)Component.m_237113_((String)"Angry Creeper"));
                } else {
                    creeper.m_6593_(null);
                }
                TagsFeature.setExplosionCausesFire((boolean)angry$fire, (LivingEntity)creeper);
                if (insaneSurvivalOverhaulIntegration.booleanValue()) {
                    creeper.getPersistentData().m_128350_("iguanatweaksreborn:explosion_knockback_multiplier", 2.0f);
                    creeper.getPersistentData().m_128350_("iguanatweaksreborn:explosion_ray_strength_multiplier", 0.01f);
                }
                if (angry$forceExplosion.booleanValue()) {
                    FORCE_EXPLODE.apply((Mob)creeper, true);
                }
                EXPLOSION_SOUND.apply((Mob)creeper, CreeperSwell.angry$sounds.name);
            } else {
                compoundNBT.m_128376_("Fuse", (short)30);
                compoundNBT.m_128344_("ExplosionRadius", (byte)3);
                if (angry$name.booleanValue()) {
                    creeper.m_6593_(null);
                }
                if (angry$fire.booleanValue()) {
                    TagsFeature.setExplosionCausesFire((boolean)false, (LivingEntity)creeper);
                }
                if (insaneSurvivalOverhaulIntegration.booleanValue()) {
                    creeper.getPersistentData().m_128473_("iguanatweaksreborn:explosion_knockback_multiplier");
                    creeper.getPersistentData().m_128473_("iguanatweaksreborn:explosion_ray_strength_multiplier");
                }
                if (angry$forceExplosion.booleanValue()) {
                    FORCE_EXPLODE.apply((Mob)creeper, false);
                }
                EXPLOSION_SOUND.apply((Mob)creeper, FuseExplodeSounds.NONE.name);
            }
            creeper.m_7378_(compoundNBT);
            MessageCreeperDataSync.syncCreeperToPlayers((Creeper)creeper);
        });
        EXPLOSION_SOUND = EAIData.ofString(this.createDataKey("explosion_sound"));
    }

    @SubscribeEvent
    public void explosionStartEvent(ExplosionEvent.Detonate event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion e = event.getExplosion();
        Entity entity = e.getExploder();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        FuseExplodeSounds fuseExplodeSounds = FuseExplodeSounds.get(living);
        if (fuseExplodeSounds != FuseExplodeSounds.NONE) {
            living.m_5496_(fuseExplodeSounds.explode.get(), 4.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void eventEntityJoinWorld(EntityJoinLevelEvent event) {
        Creeper creeper;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Creeper) || !(creeper = (Creeper)entity).m_6095_().m_204039_(CHANGE_CREEPER_SWELL)) {
            return;
        }
        if (!creeper.f_21345_.f_25345_.removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof SwellGoal)) {
            return;
        }
        EAICreeperSwellGoal swellGoal = new EAICreeperSwellGoal(creeper);
        creeper.f_21345_.m_25352_(2, (Goal)swellGoal);
        WALKING_FUSE.applyIfAbsent((Mob)creeper, creeper.m_217043_().m_188500_() < walkingFuse$chance);
        WALKING_FUSE_SPEED_MODIFIER.applyIfAbsent((Mob)creeper, walkingFuse$speedModifier);
        IGNORE_WALLS.applyIfAbsent((Mob)creeper, creeper.m_217043_().m_188500_() < ignoreWallsChance);
        BREACH.applyIfAbsent((Mob)creeper, creeper.m_217043_().m_188500_() < breach$chance);
        BREACH_HORIZONTAL_RANGE.applyIfAbsent((Mob)creeper, breach$horizontalRange.doubleValue());
        BETA_STRAFE.applyIfAbsent((Mob)creeper, creeper.m_217043_().m_188500_() < betaStrafe$chance);
        BETA_LEFT_STRAFE.apply((Mob)creeper, creeper.m_217043_().m_188499_());
        BLOW_UP_ON_DEATH.applyIfAbsent((Mob)creeper, blowUpOnDeath == BlowUpOnDeath.ALL || blowUpOnDeath == BlowUpOnDeath.CHARGED && creeper.m_7090_() || ANGRY.get((Entity)creeper) != false && angry$explodeOnDeath != false);
        ANGRY.applyIfAbsent((Mob)creeper, creeper.m_217043_().m_188500_() < angry$chance);
    }

    @SubscribeEvent
    public void onCreeperRemoved(EntityLeaveLevelEvent event) {
        Creeper creeper;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof Creeper && (creeper = (Creeper)entity).m_21224_() && !creeper.m_9236_().f_46443_ && BLOW_UP_ON_DEATH.get((Entity)creeper).booleanValue())) {
            return;
        }
        BLOW_UP_ON_DEATH.apply((Mob)creeper, false);
        creeper.m_32315_();
    }

    @SubscribeEvent
    public void onCreeperTick(LivingEvent.LivingTickEvent event) {
        Creeper creeper;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Creeper)) break block2;
                creeper = (Creeper)livingEntity;
                if (!creeper.m_9236_().f_46443_) break block3;
            }
            return;
        }
        this.onCenaCreeperTick(creeper);
    }

    public void onCenaCreeperTick(Creeper creeper) {
        if (creeper.f_19797_ % 40 != 5 || !angry$particles.booleanValue()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)creeper.m_9236_();
        if (ANGRY.get((Entity)creeper).booleanValue()) {
            for (int j = 0; j < serverLevel.m_6907_().size(); ++j) {
                ServerPlayer serverplayer = (ServerPlayer)serverLevel.m_6907_().get(j);
                BlockPos blockpos = serverplayer.m_20183_();
                if (!blockpos.m_203195_((Position)new Vec3(creeper.m_20185_(), creeper.m_20186_() + 0.5, creeper.m_20189_()), 16.0)) continue;
                serverLevel.m_8624_(serverplayer, (ParticleOptions)ParticleTypes.f_123792_, false, creeper.m_20185_(), creeper.m_20186_() + 1.1, creeper.m_20189_(), 1, 0.15, 0.15, 0.15, 0.0);
            }
        }
    }

    public static enum FuseExplodeSounds {
        NONE("none", null, null),
        CENA("cena", (Supplier<SoundEvent>)EAISounds.CREEPER_CENA_FUSE, (Supplier<SoundEvent>)EAISounds.CREEPER_CENA_EXPLODE),
        WTF_BOOM("wtf_boom", (Supplier<SoundEvent>)EAISounds.WTF_BOOM_FUSE, (Supplier<SoundEvent>)EAISounds.WTF_BOOM_EXPLODE),
        OLD("old", () -> SoundEvents.f_11837_, (Supplier<SoundEvent>)EAISounds.OLD_EXPLODE);

        public final String name;
        @Nullable
        public final Supplier<SoundEvent> fuse;
        @Nullable
        public final Supplier<SoundEvent> explode;

        private FuseExplodeSounds(@Nullable String name, Supplier<SoundEvent> fuse, Supplier<SoundEvent> explode) {
            this.name = name;
            this.fuse = fuse;
            this.explode = explode;
        }

        public static FuseExplodeSounds get(LivingEntity living) {
            String sound = EXPLOSION_SOUND.get((Entity)living);
            if (sound.isEmpty()) {
                return NONE;
            }
            for (FuseExplodeSounds fuseExplodeSounds : FuseExplodeSounds.values()) {
                if (!fuseExplodeSounds.name.equals(sound)) continue;
                return fuseExplodeSounds;
            }
            return NONE;
        }
    }

    public static enum BlowUpOnDeath {
        NONE,
        CHARGED,
        ALL;

    }
}

