/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.drowned;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.ModNBTData;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:drowned", description="Makes drowned immune to sunlight for a couple of seconds before starting to burn. Only entity types in the enhancedai:drowned/sun_resistant tag are affected by this feature.")
public class SunResistantDrowned
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("drowned/sun_resistant"));
    @Config(min=1.0, description="Drowned are sun resistant for this amount of ticks until the water in their body evaporates. During this time, they will not seek water")
    public static Integer sunResistant = 300;
    public static ResourceLocation TIME;
    public static EAIData<Integer> TICKS;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        TIME = this.createDataKey("time");
        TICKS = EAIData.ofInt(this.createDataKey("ticks"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Drowned drowned;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Drowned) || !(drowned = (Drowned)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        if (sunResistant > 0) {
            TICKS.applyIfAbsent((Mob)drowned, sunResistant);
        }
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingTickEvent event) {
        Drowned drowned;
        block11: {
            block10: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Drowned)) break block10;
                drowned = (Drowned)livingEntity;
                if (!drowned.m_9236_().f_46443_) break block11;
            }
            return;
        }
        int sunResistantTicks = TICKS.get((Entity)drowned);
        if (sunResistantTicks <= 0) {
            return;
        }
        int sunResistantTime = (Integer)ModNBTData.get((Entity)drowned, (ResourceLocation)TIME, Integer.class);
        if (drowned.m_20069_() && sunResistantTime > 0) {
            sunResistantTime -= 4;
        } else if (sunResistantTime <= sunResistantTicks && !drowned.isInFluidType() && drowned.m_9236_().m_46461_() && drowned.m_9236_().m_45527_(drowned.m_20183_())) {
            if (++sunResistantTime < sunResistantTicks) {
                drowned.m_20095_();
            } else if (sunResistantTime == sunResistantTicks) {
                drowned.m_216990_(SoundEvents.f_11914_);
            }
        }
        ModNBTData.put((Entity)drowned, (ResourceLocation)TIME, (Object)sunResistantTime);
    }
}

