/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.illager.shoot;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.illager.shoot.EAIPillagerAttackGoal;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.MinMax;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:illager", description="Use the enhancedai:illager/better_shooting entity type tag to add more skeletons that are affected by this feature")
public class PillagerShoot
extends Feature {
    public static final TagKey<EntityType<?>> BETTER_PILLAGER_SHOOT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("illager/better_shooting"));
    @Config(min=1.0, max=64.0, description="The range from where a pillager will shoot a target")
    public static MinMax shootingRange = new MinMax(24.0, 32.0);
    @Config(min=0.0, description="The ticks cooldown before shooting. Vanilla is random between 20 and 40")
    public static MinMax shootingCooldown = new MinMax(20.0, 40.0);
    @Config(min=0.0, max=30.0, description="How much inaccuracy does the arrow fired by pillagers have. Vanilla pillagers have 10/6/2 inaccuracy in easy/normal/hard difficulty.")
    public static Difficulty inaccuracy = new Difficulty(5.0, 3.0, 1.0);
    public static EAIData<Integer> SHOOTING_RANGE;
    public static EAIData<Integer> SHOOTING_COOLDOWN;
    public static EAIData<Double> INACCURACY;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        SHOOTING_RANGE = EAIData.ofInt(this.createDataKey("shooting_range"));
        SHOOTING_COOLDOWN = EAIData.ofInt(this.createDataKey("shooting_cooldown"));
        INACCURACY = EAIData.ofDouble(this.createDataKey("inaccuracy"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Pillager pillager;
        block3: {
            block2: {
                Entity entity;
                if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Pillager)) break block2;
                pillager = (Pillager)entity;
                if (event.getEntity().m_6095_().m_204039_(BETTER_PILLAGER_SHOOT)) break block3;
            }
            return;
        }
        GoalHelper.removeGoal(pillager.f_21345_, RangedCrossbowAttackGoal.class);
        pillager.f_21345_.m_25352_(3, (Goal)new EAIPillagerAttackGoal(pillager, 1.0));
        SHOOTING_RANGE.applyIfAbsent((Mob)pillager, shootingRange.getIntRandBetween(pillager.m_217043_()));
        SHOOTING_COOLDOWN.applyIfAbsent((Mob)pillager, shootingCooldown.getIntRandBetween(pillager.m_217043_()));
        INACCURACY.applyIfAbsent((Mob)pillager, inaccuracy.getByDifficulty(pillager.m_9236_()));
    }

    @SubscribeEvent
    public void onPillagerHitAlly(LivingHurtEvent event) {
        Pillager shooter;
        Pillager hitPillager;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Pillager)) break block2;
                hitPillager = (Pillager)livingEntity;
                livingEntity = event.getSource().m_7639_();
                if (!(livingEntity instanceof Pillager)) break block2;
                shooter = (Pillager)livingEntity;
                if (event.getSource().m_7640_() instanceof AbstractArrow) break block3;
            }
            return;
        }
        PillagerShoot.tryReposition(shooter, (Entity)hitPillager, 3);
    }

    public static void tryReposition(Pillager pillager, @Nullable Entity ally, int baseDistance) {
        double distance = baseDistance;
        if (ally != null && pillager.m_5448_() != null) {
            distance += (double)Mth.m_14036_((float)(10.0f - ally.m_20270_((Entity)pillager.m_5448_())), (float)0.0f, (float)10.0f);
        }
        Vec3 viewVector = pillager.m_20252_(1.0f);
        Vec3 sideVector = viewVector.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(distance);
        Vec3 position = pillager.m_20182_();
        Vec3 targetPos = position.m_82549_(sideVector.m_82490_(pillager.m_217043_().m_188499_() ? 1.0 : -1.0));
        pillager.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.0);
    }

    @Nullable
    public static Entity mightHitAnAlly(Pillager pillager, double distance) {
        AABB aabb;
        double distanceNotSqr = Math.sqrt(distance);
        Vec3 from = pillager.m_20299_(0.5f);
        Vec3 viewVec = pillager.m_20252_(0.5f);
        Vec3 to = from.m_82520_(viewVec.f_82479_ * distanceNotSqr, viewVec.f_82480_ * distanceNotSqr, viewVec.f_82481_ * distanceNotSqr);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)pillager, (Vec3)from, (Vec3)to, (AABB)(aabb = pillager.m_20191_().m_82369_(viewVec.m_82490_(distanceNotSqr)).m_82377_(1.0, 1.0, 1.0)), entity -> entity.m_6095_().m_204039_(EntityTypeTags.f_13121_), (double)distance);
        return entityHitResult == null ? null : entityHitResult.m_82443_();
    }
}

