/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.setup.EAIAttributes;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="enhancedai:mobs", description="Allows mobs to call reinforcements (like vanilla zombies can, but better) and have leaders that have a high chance to call reinforcements. Only entity types in the `enhancedai:mobs/leaders` tag can jump. PLEASE NOTE that this feature uses a custom attribute (enhancedai:spawn_reinforcements_chance) instead of the vanilla one. This feature has also an MPR condition `enhancedai:is_leader` to check if the mob is a leader.")
public class Leaders
extends Feature {
    private static final UUID BONUS_STATS_UUID = UUID.fromString("359f73af-4f99-4d5c-82dc-693b252793c5");
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/leaders"));
    public static final RegistryObject<Attribute> SPAWN_REINFORCEMENTS_CHANCE = EAIAttributes.ATTRIBUTES.register("spawn_reinforcements_chance", () -> new RangedAttribute("attribute.name.spawn_reinforcements_chance", 0.0, 0.0, Double.MAX_VALUE));
    @Config(min=0.0, max=1.0, description="Chance for a mob to become a leader. Leader mobs have a high chance to spawn reinforcements.")
    public static Double leaderChance = 0.05;
    @Config(min=0.0, description="At this damage, the chance to spawn reinforcements is 100% of the attribute, otherwise is scaled. E.g. with this set to 6 and enhancedai:spawn_reinforcements_chance attribute set to 0.5 the chance to spawn reinforcements is 50% at 6 damage, 25% at 3 damage or 100% at 12 damage. Set to 0 to disable scaling with damage. This is damage before resistances (armor, etc).")
    public static Double spawnReinforcementsChanceDamageScaled = 6.0;
    @Config(description="How much is enhancedai:spawn_reinforcements_chance reduced by each time a reinforcement is spawned.")
    public static Double chargePerSpawn = 0.05;
    @Config
    public static Double leaderSpawnReinforcementsChance = 1.0;
    @Config
    public static Boolean reinforcesCanSpawnAsLeader = false;
    @Config(description="If true, leader mobs will have 4x health and +15 armor.")
    public static Boolean bonusStats = true;
    @Config
    public static Boolean removeVanillaSpawnReinforcementsChance = true;
    public static EAIData<Boolean> LEADER;
    public static EAIData<Double> CHARGE_PER_SPAWN;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        LEADER = EAIData.ofBool(this.createDataKey("leader"), (mob, leader) -> {
            if (leader.booleanValue()) {
                MCUtils.applyModifier((LivingEntity)mob, (Attribute)((Attribute)SPAWN_REINFORCEMENTS_CHANCE.get()), (UUID)BONUS_STATS_UUID, (String)"Enhanced AI Leader Spawn Reinforcements Chance", (double)leaderSpawnReinforcementsChance, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
            } else {
                mob.m_21051_((Attribute)SPAWN_REINFORCEMENTS_CHANCE.get()).m_22120_(BONUS_STATS_UUID);
            }
            if (!bonusStats.booleanValue()) {
                return;
            }
            if (leader.booleanValue()) {
                MCUtils.applyModifier((LivingEntity)mob, (Attribute)Attributes.f_22276_, (UUID)BONUS_STATS_UUID, (String)"Enhanced AI Leader Health", (double)3.0, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
                MCUtils.applyModifier((LivingEntity)mob, (Attribute)Attributes.f_22284_, (UUID)BONUS_STATS_UUID, (String)"Enhanced AI Leader Armor", (double)15.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
            } else {
                mob.m_21051_(Attributes.f_22276_).m_22120_(BONUS_STATS_UUID);
                mob.m_21051_(Attributes.f_22284_).m_22120_(BONUS_STATS_UUID);
            }
        });
        CHARGE_PER_SPAWN = EAIData.ofDouble(this.createDataKey("charge_per_spawn"));
    }

    public static void attribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)SPAWN_REINFORCEMENTS_CHANCE.get())) continue;
            event.add(entityType, (Attribute)SPAWN_REINFORCEMENTS_CHANCE.get(), 0.0);
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        Mob reinforcement;
        Entity entity;
        ServerLevel serverLevel;
        Mob mob;
        block19: {
            block18: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Mob) || !((livingEntity = (mob = (Mob)livingEntity).m_9236_()) instanceof ServerLevel)) break block18;
                serverLevel = (ServerLevel)livingEntity;
                if (event.getSource().m_7639_() != null) break block19;
            }
            return;
        }
        double chance = mob.m_21133_((Attribute)SPAWN_REINFORCEMENTS_CHANCE.get());
        if (chance <= 0.0) {
            return;
        }
        if (spawnReinforcementsChanceDamageScaled > 0.0) {
            chance *= (double)event.getAmount() / spawnReinforcementsChanceDamageScaled;
        }
        if (mob.m_217043_().m_188500_() >= chance) {
            return;
        }
        int x = mob.m_146903_();
        int y = mob.m_146904_();
        int z = mob.m_146907_();
        LivingEntity target = mob.m_5448_();
        if (target == null && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker;
            target = attacker = (LivingEntity)entity;
        }
        if ((reinforcement = (Mob)mob.m_6095_().m_20615_(mob.m_9236_())) == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int x1 = x + Mth.m_216271_((RandomSource)mob.m_217043_(), (int)7, (int)30) * Mth.m_216271_((RandomSource)mob.m_217043_(), (int)-1, (int)1);
            int z1 = z + Mth.m_216271_((RandomSource)mob.m_217043_(), (int)7, (int)30) * Mth.m_216271_((RandomSource)mob.m_217043_(), (int)-1, (int)1);
            int worldHeight = mob.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x1, z1);
            int y1 = y + Mth.m_216271_((RandomSource)mob.m_217043_(), (int)-20, (int)20);
            if (y1 > worldHeight) {
                y1 = worldHeight + 1;
            }
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x1, y1, z1);
            EntityType entitytype = reinforcement.m_6095_();
            SpawnPlacements.Type spawnplacements$type = SpawnPlacements.m_21752_((EntityType)entitytype);
            reinforcement.m_6034_((double)x1 + 0.5, (double)y1, (double)z1 + 0.5);
            boolean foundSpawnPosition = true;
            if (y1 < worldHeight) {
                while (!(NaturalSpawner.m_47051_((SpawnPlacements.Type)spawnplacements$type, (LevelReader)mob.m_9236_(), (BlockPos)blockPos, (EntityType)entitytype) && SpawnPlacements.m_217074_((EntityType)entitytype, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockPos, (RandomSource)mob.m_9236_().f_46441_) && mob.m_9236_().m_45784_((Entity)reinforcement) && mob.m_9236_().m_45786_((Entity)reinforcement) && !mob.m_9236_().m_46855_(reinforcement.m_20191_()))) {
                    if (++y1 >= mob.m_9236_().m_151558_() || y1 > worldHeight + 1) {
                        foundSpawnPosition = false;
                        break;
                    }
                    blockPos.m_122178_(x1, y1, z1);
                    reinforcement.m_6034_((double)x1 + 0.5, (double)y1, (double)z1 + 0.5);
                }
            }
            if (!foundSpawnPosition) {
                foundSpawnPosition = true;
                while (!(NaturalSpawner.m_47051_((SpawnPlacements.Type)spawnplacements$type, (LevelReader)mob.m_9236_(), (BlockPos)blockPos, (EntityType)entitytype) && SpawnPlacements.m_217074_((EntityType)entitytype, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockPos, (RandomSource)mob.m_9236_().f_46441_) && mob.m_9236_().m_45784_((Entity)reinforcement) && mob.m_9236_().m_45786_((Entity)reinforcement) && !mob.m_9236_().m_46855_(reinforcement.m_20191_()))) {
                    if (--y1 <= mob.m_9236_().m_141937_()) {
                        foundSpawnPosition = false;
                        break;
                    }
                    blockPos.m_122178_(x1, y1, z1);
                    reinforcement.m_6034_((double)x1 + 0.5, (double)y1, (double)z1 + 0.5);
                }
            }
            if (!foundSpawnPosition || mob.m_9236_().m_45914_((double)x1, (double)y1, (double)z1, 7.0)) continue;
            if (target != null) {
                reinforcement.m_6710_(target);
            }
            reinforcement.m_6518_((ServerLevelAccessor)serverLevel, mob.m_9236_().m_6436_(reinforcement.m_20183_()), MobSpawnType.REINFORCEMENT, null, null);
            if (!reinforcesCanSpawnAsLeader.booleanValue()) {
                LEADER.applyIfAbsent(reinforcement, false);
            }
            serverLevel.m_47205_((Entity)reinforcement);
            MCUtils.applyModifier((LivingEntity)mob, (Attribute)((Attribute)SPAWN_REINFORCEMENTS_CHANCE.get()), (UUID)UUID.randomUUID(), (String)"Reinforcement caller charge", (double)(-chargePerSpawn.doubleValue()), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
            MCUtils.applyModifier((LivingEntity)reinforcement, (Attribute)((Attribute)SPAWN_REINFORCEMENTS_CHANCE.get()), (UUID)UUID.randomUUID(), (String)"Reinforcement callee charge", (double)(-chargePerSpawn.doubleValue()), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
            break;
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        LEADER.applyIfAbsent(mob, mob.m_217043_().m_188500_() < leaderChance);
        CHARGE_PER_SPAWN.applyIfAbsent(mob, chargePerSpawn);
        if (removeVanillaSpawnReinforcementsChance.booleanValue() && mob.m_21051_(Attributes.f_22287_) != null) {
            mob.m_21051_(Attributes.f_22287_).m_22132_();
            mob.m_21051_(Attributes.f_22287_).m_22100_(0.0);
        }
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingTickEvent event) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                Level level;
                if (!LEADER.get((Entity)event.getEntity()).booleanValue() || !((level = event.getEntity().m_9236_()) instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if ((event.getEntity().f_19797_ + event.getEntity().m_19879_()) % 10 == 0) break block3;
            }
            return;
        }
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123751_, event.getEntity().m_20185_(), event.getEntity().m_20188_(), event.getEntity().m_20189_(), 1, 0.25, 0.25, 0.25, 0.0);
    }

    public static boolean isLeader(LivingEntity entity) {
        return LEADER.get((Entity)entity);
    }
}

