/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Only entity types in `enhancedai:mobs/can_open_doors` tag are affected by this feature.")
public class OpenDoors
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_open_doors"));
    public static EAIData<Boolean> CAN_OPEN_DOORS;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CAN_OPEN_DOORS = EAIData.ofBool(this.createDataKey("can_open_doors"), (mob, canOpenDoors) -> {
            PathNavigation patt1579$temp;
            GoalHelper.removeGoal(mob.f_21345_, OpenDoorGoal.class);
            if (canOpenDoors.booleanValue()) {
                mob.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal(mob, false));
            }
            if ((patt1579$temp = mob.m_21573_()) instanceof GroundPathNavigation) {
                GroundPathNavigation groundPathNavigation = (GroundPathNavigation)patt1579$temp;
                groundPathNavigation.m_26477_(canOpenDoors.booleanValue());
            }
        });
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        block3: {
            block2: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Mob)) break block2;
                mob = (Mob)entity;
                if (!Spawning.isUnaffectedByFeatures(event.getEntity()) && OpenDoors.shouldBeAbleToOpenDoors(mob) && !event.getLevel().f_46443_) break block3;
            }
            return;
        }
        CAN_OPEN_DOORS.applyIfAbsent(mob, true);
    }

    public static boolean shouldBeAbleToOpenDoors(Mob mob) {
        return Feature.isEnabled(OpenDoors.class) && mob.m_6095_().m_204039_(AFFECTED_ENTITY_TYPES);
    }
}

