/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs panic when on fire.")
public class Panic
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/panic_on_fire"));
    @Config(min=0.0, max=1.0, description="Chance for a mob to get the panic on fire AI")
    public static Double chance = 0.8;
    public static EAIData<Boolean> PANIC_ON_FIRE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        PANIC_ON_FIRE = EAIData.ofBool(this.createDataKey("panic_on_fire"), (mob, panicOnFire) -> {
            if (!(mob instanceof PathfinderMob)) {
                return;
            }
            PathfinderMob pMob = (PathfinderMob)mob;
            if (panicOnFire.booleanValue()) {
                mob.f_21345_.m_25352_(1, (Goal)new EAIPanicGoal(pMob, 1.25));
            }
        });
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        PathfinderMob mob;
        block3: {
            block2: {
                Entity entity;
                if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof PathfinderMob)) break block2;
                mob = (PathfinderMob)entity;
                if (event.getEntity().m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) break block3;
            }
            return;
        }
        PANIC_ON_FIRE.applyIfAbsent((Mob)mob, mob.m_217043_().m_188500_() < chance);
    }

    public static class EAIPanicGoal
    extends Goal {
        protected final PathfinderMob mob;
        protected final double speedModifier;
        protected double posX;
        protected double posY;
        protected double posZ;
        protected boolean isRunning;

        public EAIPanicGoal(PathfinderMob pMob, double pSpeedModifier) {
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.mob.m_6060_()) {
                return false;
            }
            BlockPos blockpos = this.lookForWater((BlockGetter)this.mob.m_9236_(), (Entity)this.mob, 5);
            if (blockpos != null) {
                this.posX = blockpos.m_123341_();
                this.posY = blockpos.m_123342_();
                this.posZ = blockpos.m_123343_();
                return true;
            }
            return this.findRandomPosition();
        }

        protected boolean findRandomPosition() {
            Vec3 vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)5, (int)4);
            if (vec3 == null) {
                return false;
            }
            this.posX = vec3.f_82479_;
            this.posY = vec3.f_82480_;
            this.posZ = vec3.f_82481_;
            return true;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
            this.isRunning = true;
        }

        public void m_8041_() {
            this.isRunning = false;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        @Nullable
        protected BlockPos lookForWater(BlockGetter pLevel, Entity pEntity, int pRange) {
            BlockPos blockpos = pEntity.m_20183_();
            return !pLevel.m_8055_(blockpos).m_60812_(pLevel, blockpos).m_83281_() ? null : (BlockPos)BlockPos.m_121930_((BlockPos)pEntity.m_20183_(), (int)pRange, (int)1, p_196649_ -> pLevel.m_6425_(p_196649_).m_205070_(FluidTags.f_13131_)).orElse(null);
        }
    }
}

