/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.fallingshockwave;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.fallingshockwave.FallingShockwaveGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Mobs will jump off the ground to emit a shockwave when falling damaging nearby entities. Only entity types in enhancedai:mobs/shockwave/can_use tag are affected by this feature and entity types in the enhancedai:mobs/shockwave/damage_invulnerable tag will not be damaged by the shockwave.")
public class FallingShockwave
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/shockwave/can_use"));
    public static final TagKey<EntityType<?>> SHOCKWAVE_INVULNERABLE_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/shockwave/damage_invulnerable"));
    ResourceKey<DamageType> DAMAGE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)EnhancedAI.location("shockwave"));
    @Config(min=0.0)
    public static Double jumpStrength = 1.5;
    @Config(min=0.0, description="In ticks")
    public static Integer jumpCooldown = 300;
    @Config(min=0.0, description="Damage per block of fall distance.")
    public static Double damagePerBlock = 1.0;
    @Config(min=0.0, description="Fall distance multiplied by this")
    public static Double knockupStrengthRatio = 0.08;
    @Config(min=0.0)
    public static Double horizontalBaseRange = 2.0;
    @Config(min=0.0)
    public static Double verticalBaseRange = 1.0;
    @Config(min=0.0)
    public static Double horizontalRangePerBlock = 0.2;
    @Config(min=0.0)
    public static Double verticalRangePerBlock = 0.1;
    public static EAIData<Double> JUMP_STRENGTH;
    public static EAIData<Integer> JUMP_COOLDOWN;
    public static EAIData<Double> DAMAGE_PER_BLOCK;
    public static EAIData<Double> KNOCKUP_STRENGTH_RATIO;
    public static EAIData<Double> HORIZONTAL_BASE_RANGE;
    public static EAIData<Double> VERTICAL_BASE_RANGE;
    public static EAIData<Double> HORIZONTAL_RANGE_PER_BLOCK;
    public static EAIData<Double> VERTICAL_RANGE_PER_BLOCK;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        JUMP_STRENGTH = EAIData.ofDouble(this.createDataKey("jump_strength"), (mob, value) -> {
            GoalHelper.removeGoal(mob.f_21345_, FallingShockwaveGoal.class);
            if (value > 0.0) {
                mob.f_21345_.m_25352_(1, (Goal)new FallingShockwaveGoal((Mob)mob));
            }
        });
        JUMP_COOLDOWN = EAIData.ofInt(this.createDataKey("jump_cooldown"));
        DAMAGE_PER_BLOCK = EAIData.ofDouble(this.createDataKey("damage_per_block"));
        KNOCKUP_STRENGTH_RATIO = EAIData.ofDouble(this.createDataKey("knockup_strength_ratio"));
        HORIZONTAL_BASE_RANGE = EAIData.ofDouble(this.createDataKey("horizontal_base_range"));
        VERTICAL_BASE_RANGE = EAIData.ofDouble(this.createDataKey("vertical_base_range"));
        HORIZONTAL_RANGE_PER_BLOCK = EAIData.ofDouble(this.createDataKey("horizontal_range_per_block"));
        VERTICAL_RANGE_PER_BLOCK = EAIData.ofDouble(this.createDataKey("vertical_range_per_block"));
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        double damage = DAMAGE_PER_BLOCK.get((Entity)entity);
        if (damage <= 0.0) {
            return;
        }
        if ((double)event.getDistance() < 1.0) {
            return;
        }
        damage *= (double)(event.getDistance() - 1.0f);
        double horizontalBaseRange = HORIZONTAL_BASE_RANGE.get((Entity)entity);
        double horizontalRangePerBlock = HORIZONTAL_RANGE_PER_BLOCK.get((Entity)entity);
        double horizontalRange = horizontalBaseRange + horizontalRangePerBlock * (double)(event.getDistance() - 1.0f);
        double verticalBaseRange = VERTICAL_BASE_RANGE.get((Entity)entity);
        double verticalRangePerBlock = VERTICAL_RANGE_PER_BLOCK.get((Entity)entity);
        double verticalRange = verticalBaseRange + verticalRangePerBlock * (double)(event.getDistance() - 1.0f);
        Level level = entity.m_9236_();
        for (LivingEntity target : level.m_45976_(LivingEntity.class, entity.m_20191_().m_165887_(entity.m_20186_()).m_165893_(entity.m_20186_()).m_82377_(horizontalRange, verticalRange, horizontalRange))) {
            if (entity == target || !target.m_20096_() || target.m_6095_().m_204039_(SHOCKWAVE_INVULNERABLE_ENTITY_TYPES)) continue;
            target.m_6469_(entity.m_269291_().m_269298_(this.DAMAGE_TYPE, (Entity)entity), (float)damage);
            target.m_20256_(target.m_20184_().m_82520_(0.0, (double)(event.getDistance() - 1.0f) * KNOCKUP_STRENGTH_RATIO.get((Entity)entity), 0.0));
            target.f_19864_ = true;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (int)(50.0 * horizontalRange * verticalRange), horizontalRange, verticalRange, horizontalRange, 0.0);
            serverLevel.m_6269_(null, (Entity)entity, SoundEvents.f_12058_, SoundSource.PLAYERS, 2.0f, 0.5f);
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        JUMP_STRENGTH.applyIfAbsent(mob, jumpStrength);
        JUMP_COOLDOWN.applyIfAbsent(mob, jumpCooldown);
        DAMAGE_PER_BLOCK.applyIfAbsent(mob, damagePerBlock);
        KNOCKUP_STRENGTH_RATIO.applyIfAbsent(mob, knockupStrengthRatio);
        HORIZONTAL_BASE_RANGE.applyIfAbsent(mob, horizontalBaseRange);
        VERTICAL_BASE_RANGE.applyIfAbsent(mob, verticalBaseRange);
        HORIZONTAL_RANGE_PER_BLOCK.applyIfAbsent(mob, horizontalRangePerBlock);
        VERTICAL_RANGE_PER_BLOCK.applyIfAbsent(mob, verticalRangePerBlock);
    }
}

