/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.pearler;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.pearler.PearlUseGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.ModNBTData;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Let mobs use ender pearls as long as they have them in the off hand and when far enough from the target. Only mobs in the enhancedai:mobs/can_equip_pearl entity type tag will try to be equipped ender pearls.")
public class PearlerMobs
extends Feature {
    public static final TagKey<EntityType<?>> CAN_EQUIP_PEARL = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_equip_pearl"));
    @Config(min=0.0, max=1.0, description="Chance for a mob to spawn with Ender Pearls in the offhand.\nI recommend Mobs Properties Randomness to have more control over mobs equipment.")
    public static Double equipEnderPearlChance = 0.05;
    @Config(min=0.0, max=16.0, description="How many ender pearls will Mobs spawn with.")
    public static MinMax enderPearlAmount = new MinMax(2.0, 4.0);
    @Config(min=1.0, max=16.0, description="Inaccuracy when throwing the ender pearl.")
    public static Integer inaccuracy = 3;
    public static ResourceLocation HAS_ENDER_PEARL_BEEN_GIVEN;
    public static EAIData<Integer> INACCURACY;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        HAS_ENDER_PEARL_BEEN_GIVEN = this.createDataKey("has_ender_pearl_been_given");
        INACCURACY = EAIData.ofInt(this.createDataKey("inaccuracy"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_EQUIP_PEARL) || ((Boolean)ModNBTData.get((Entity)mob, (ResourceLocation)HAS_ENDER_PEARL_BEEN_GIVEN, Boolean.class)).booleanValue()) {
            return;
        }
        if (mob.m_21206_().m_41619_() && mob.m_217043_().m_188500_() < equipEnderPearlChance) {
            mob.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42584_, enderPearlAmount.getIntRandBetween(mob.m_217043_())));
        }
        ModNBTData.put((Entity)mob, (ResourceLocation)HAS_ENDER_PEARL_BEEN_GIVEN, (Object)true);
        mob.f_21345_.m_25352_(2, (Goal)new PearlUseGoal(mob));
        INACCURACY.applyIfAbsent(mob, inaccuracy);
    }
}

