/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.riding;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.riding.SearchMountGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.util.ModNBTData;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs ride other mobs. Mobs in the `enhancedai:mobs/riding/can_be_mounted` tag will be able to be mounted, while mobs in the `enhancedai:mobs/riding/can_mount` tag will be able to mount other mobs.")
public class Riding
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_MOUNTED = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/riding/can_be_mounted"));
    public static final TagKey<EntityType<?>> CAN_MOUNT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/riding/can_mount"));
    @Config(min=0.0, max=1.0, description="Chance for a mob to have an AI to go and ride mobs.")
    public static Difficulty chance = new Difficulty(0.03, 0.06, 0.1);
    @Config(description="If true, riding mobs will dismount if take too much suffocation damage.")
    public static Boolean stopMountingIfSuffocating = true;
    public static ResourceLocation SUFFOCATION_WHILE_RIDING;
    public static EAIData<String> CAN_MOUNT_DATA;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        SUFFOCATION_WHILE_RIDING = this.createDataKey("suffocation_while_riding");
        CAN_MOUNT_DATA = EAIData.ofString(this.createDataKey("can_mount"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_MOUNT)) {
            return;
        }
        if (mob.m_217043_().m_188500_() < chance.getByDifficulty(mob.m_9236_())) {
            CAN_MOUNT_DATA.applyIfAbsent(mob, CAN_BE_MOUNTED.f_203868_().toString());
        }
        mob.f_21346_.m_25352_(1, (Goal)new SearchMountGoal(mob));
    }

    @SubscribeEvent
    public void onDamageTaken(LivingDamageEvent event) {
        Mob mob;
        block6: {
            block5: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Mob)) break block5;
                mob = (Mob)livingEntity;
                if (stopMountingIfSuffocating.booleanValue() && event.getSource().m_276093_(DamageTypes.f_268612_) && event.getEntity().m_20202_() != null) break block6;
            }
            return;
        }
        float suffocatingDamageTaken = ((Float)ModNBTData.get((Entity)mob, (ResourceLocation)SUFFOCATION_WHILE_RIDING, Float.class)).floatValue();
        if ((suffocatingDamageTaken += event.getAmount()) >= 6.0f) {
            mob.m_8127_();
            ModNBTData.remove((Entity)mob, (ResourceLocation)SUFFOCATION_WHILE_RIDING);
        } else {
            ModNBTData.put((Entity)mob, (ResourceLocation)SUFFOCATION_WHILE_RIDING, (Object)Float.valueOf(suffocatingDamageTaken));
        }
    }
}

