/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.targeting;

import insane96mcp.enhancedai.modules.mobs.targeting.CustomHostileConfig;
import insane96mcp.enhancedai.modules.mobs.targeting.EAINearestAttackableTarget;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomTargeting
extends JsonFeature {
    public static final String IS_NEUTRAL = "enhancedai:is_neutral";
    public static final List<CustomHostileConfig> CUSTOM_HOSTILE_DEFAULT_LIST = List.of(new CustomHostileConfig(2, IdTagMatcher.newTag((String)"enhancedai:config/can_attack_villagers"), IdTagMatcher.newId((String)"minecraft:villager"), 0.5), new CustomHostileConfig(2, IdTagMatcher.newTag((String)"enhancedai:config/can_attack_iron_golem"), IdTagMatcher.newId((String)"minecraft:iron_golem"), 0.5));
    public static final List<CustomHostileConfig> customHostile = new ArrayList<CustomHostileConfig>();
    @Config(description="Chance for a mob to be able to forget about it's target. If the mob can forget the target it will forget about it after 'Unseen forgot ticks' have passed.")
    public static Double forgetTargetChance = 0.1;
    @Config(description="If the mob can forget the target it will forget about it after this amount of ticks have passed while not seeing the target.")
    public static Integer unseenForgotTicks = 400;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("custom_hostile.json", customHostile, CUSTOM_HOSTILE_DEFAULT_LIST, CustomHostileConfig.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/enhancedai";
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        this.processCustomTargetGoal(mob);
    }

    private void processCustomTargetGoal(Mob mob) {
        if (customHostile.isEmpty()) {
            return;
        }
        for (CustomHostileConfig chc : customHostile) {
            if (!chc.attacker.matchesEntity((Entity)mob) || (double)mob.m_217043_().m_188501_() > chc.chance) continue;
            EAINearestAttackableTarget<LivingEntity> targetGoal = new EAINearestAttackableTarget<LivingEntity>(mob, LivingEntity.class, chc.victim, chc.mustSee, false, TargetingConditions.m_148352_());
            mob.f_21346_.m_25352_(chc.priority, targetGoal);
        }
    }
}

