/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.webber;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.webber.TemporaryCobwebTask;
import insane96mcp.enhancedai.modules.mobs.webber.WebThrowGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.world.scheduled.ScheduledTasks;
import insane96mcp.insanelib.world.scheduled.ScheduledTickTask;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs throw a web at a player, slowing them. Only entity types in the `enhancedai:mobs/throwing_web/can_throw_webs` tag will be affected. Entity types in `enhancedai:mobs/throwing_web/poisonous_webs` will throw poisonous webs and apply poison the same way as when a cave spider attacks an entity.")
public class ThrowingWeb
extends Feature {
    public static final TagKey<EntityType<?>> CAN_THROW_WEBS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/throwing_web/can_throw_webs"));
    public static final TagKey<EntityType<?>> POISONOUS_WEBS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/throwing_web/poisonous_webs"));
    @Config(min=0.0, max=1.0, description="Chance for a mob to spawn with the ability to throw webs at the target. Only entity types in the `enhancedai:mobs/throwing_web/can_throw_webs` tag are affected.")
    public static Double chance = 0.1;
    @Config
    public static Boolean placeWebOnBlockHit = false;
    @Config
    public static Boolean placeWebOnEntityHit = false;
    @Config(description="If true, entity types in `enhancedai:mobs/throwing_web/poisonous_webs` tag thrown webs' will poison entities hit like when cave spiders hit entity in melee.")
    public static Boolean poisonousWebs = true;
    @Config(min=-1.0, max=6000.0, description="After how many ticks will the cobweb placed by the web projectile be destroyed? Setting to -1 will prevent the cobweb from being destroyed.")
    public static Integer destroyWebAfter = 100;
    @Config(min=0.0, max=128.0, description="Damage when the projectiles hits a mob. The damage is set for normal difficulty. Hard difficulty gets +50% damage and Easy gets (-50% + 1) damage.")
    public static Double damage = 3.0;
    @Config(min=1.0, max=1200.0, description="Every how many ticks do mobs throw the projectile")
    public static MinMax cooldown = new MinMax(40.0, 60.0);
    @Config(min=0.0, max=64.0, description="Distance Required for the mobs to throw webs. Setting 'Minimum' to 0 will make the mob throw webs even when attacking the player.")
    public static MinMax distance = new MinMax(2.5, 32.0);
    @Config(description="If true, throwers will gain a speed boost when they hit the target but 5 seconds will be added to to cooldown.")
    public static Boolean applySpeed = true;
    @Config(description="If true entities will get slowness when hit.")
    public static Boolean slowness$enable = true;
    @Config(min=0.0, max=6000.0, description="How many ticks of slowness are applied to the target hit by the web?")
    public static Integer slowness$duration = 120;
    @Config(min=0.0, max=128.0, description="How many levels of slowness are applied to the target hit by the web?")
    public static Integer slowness$amplifier = 0;
    @Config(description="Should multiple hits on a target with slowness increase the level of Slowness? (This works with any type of slowness)")
    public static Boolean slowness$stackAmplifier = false;
    @Config(min=0.0, max=128.0, description="How many max levels of slowness can be applied to the target if Staking amplifier is enabled?")
    public static Integer slowness$maxSlownessAmplifier = 2;
    public static EAIData<Boolean> WEB_THROWER;
    public static EAIData<Boolean> POISONOUS_WEB;
    public static EAIData<Boolean> PLACE_WEB_ON_BLOCK_HIT;
    public static EAIData<Boolean> PLACE_WEB_ON_ENTITY_HIT;
    public static EAIData<Integer> DESTROY_WEB_AFTER;
    public static EAIData<Double> DAMAGE;
    public static EAIData<Integer> COOLDOWN;
    public static EAIData<Double> DISTANCE_MIN;
    public static EAIData<Double> DISTANCE_MAX;
    public static EAIData<Boolean> APPLY_SPEED;
    public static EAIData<Boolean> APPLY_SLOWNESS;
    public static EAIData<Integer> SLOWNESS_DURATION;
    public static EAIData<Integer> SLOWNESS_AMPLIFIER;
    public static EAIData<Boolean> SLOWNESS_STACK_AMPLIFIER;
    public static EAIData<Integer> SLOWNESS_MAX_SLOWNESS_AMPLIFIER;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        WEB_THROWER = EAIData.ofBool(this.createDataKey("web_thrower"), (mob, canThrowWebs) -> {
            GoalHelper.removeGoal(mob.f_21345_, WebThrowGoal.class);
            if (canThrowWebs.booleanValue()) {
                mob.f_21345_.m_25352_(2, (Goal)new WebThrowGoal((Mob)mob));
            }
        });
        POISONOUS_WEB = EAIData.ofBool(this.createDataKey("poisonous_web"));
        PLACE_WEB_ON_BLOCK_HIT = EAIData.ofBool(this.createDataKey("place_web_on_block_hit"));
        PLACE_WEB_ON_ENTITY_HIT = EAIData.ofBool(this.createDataKey("place_web_on_entity_hit"));
        DESTROY_WEB_AFTER = EAIData.ofInt(this.createDataKey("destroy_web_after"));
        DAMAGE = EAIData.ofDouble(this.createDataKey("damage"));
        COOLDOWN = EAIData.ofInt(this.createDataKey("cooldown"));
        DISTANCE_MIN = EAIData.ofDouble(this.createDataKey("distance_min"));
        DISTANCE_MAX = EAIData.ofDouble(this.createDataKey("distance_max"));
        APPLY_SPEED = EAIData.ofBool(this.createDataKey("apply_speed"));
        APPLY_SLOWNESS = EAIData.ofBool(this.createDataKey("slowness/enable"));
        SLOWNESS_DURATION = EAIData.ofInt(this.createDataKey("slowness/duration"));
        SLOWNESS_AMPLIFIER = EAIData.ofInt(this.createDataKey("slowness/amplifier"));
        SLOWNESS_STACK_AMPLIFIER = EAIData.ofBool(this.createDataKey("slowness/stack_amplifier"));
        SLOWNESS_MAX_SLOWNESS_AMPLIFIER = EAIData.ofInt(this.createDataKey("slowness/max_slowness_amplifier"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (mob.m_6095_().m_204039_(CAN_THROW_WEBS)) {
            WEB_THROWER.applyIfAbsent(mob, mob.m_217043_().m_188500_() < chance);
            PLACE_WEB_ON_BLOCK_HIT.applyIfAbsent(mob, placeWebOnBlockHit);
            PLACE_WEB_ON_ENTITY_HIT.applyIfAbsent(mob, placeWebOnEntityHit);
            DESTROY_WEB_AFTER.applyIfAbsent(mob, destroyWebAfter);
            DAMAGE.applyIfAbsent(mob, damage);
            COOLDOWN.applyIfAbsent(mob, cooldown.getIntRandBetween(mob.m_217043_()));
            DISTANCE_MIN.applyIfAbsent(mob, ThrowingWeb.distance.min);
            DISTANCE_MAX.applyIfAbsent(mob, ThrowingWeb.distance.max);
            APPLY_SPEED.applyIfAbsent(mob, applySpeed);
            APPLY_SLOWNESS.applyIfAbsent(mob, slowness$enable);
            SLOWNESS_DURATION.applyIfAbsent(mob, slowness$duration);
            SLOWNESS_AMPLIFIER.applyIfAbsent(mob, slowness$amplifier);
            SLOWNESS_STACK_AMPLIFIER.applyIfAbsent(mob, slowness$stackAmplifier);
            SLOWNESS_MAX_SLOWNESS_AMPLIFIER.applyIfAbsent(mob, slowness$maxSlownessAmplifier);
            if (mob.m_6095_().m_204039_(POISONOUS_WEBS)) {
                POISONOUS_WEB.applyIfAbsent(mob, poisonousWebs);
            }
        }
    }

    public static void applyEffects(Entity thrower, LivingEntity entityHit) {
        ThrowingWeb.applySlowness(thrower, entityHit);
        ThrowingWeb.applyPoison(thrower, entityHit);
    }

    public static void applySlowness(Entity thrower, LivingEntity entityHit) {
        if (!APPLY_SLOWNESS.get(thrower).booleanValue()) {
            return;
        }
        MobEffectInstance slowness = entityHit.m_21124_(MobEffects.f_19597_);
        if (SLOWNESS_STACK_AMPLIFIER.get(thrower).booleanValue() && slowness != null) {
            entityHit.m_7292_(new MobEffectInstance(MobEffects.f_19597_, SLOWNESS_DURATION.get(thrower).intValue(), Math.min(slowness.m_19564_() + SLOWNESS_AMPLIFIER.get(thrower) + 1, SLOWNESS_MAX_SLOWNESS_AMPLIFIER.get(thrower) - 1), false, false, true));
        } else {
            entityHit.m_7292_(new MobEffectInstance(MobEffects.f_19597_, SLOWNESS_DURATION.get(thrower).intValue(), SLOWNESS_AMPLIFIER.get(thrower).intValue(), false, false, true));
        }
    }

    public static void applyPoison(Entity thrower, LivingEntity entityHit) {
        if (!POISONOUS_WEB.get(thrower).booleanValue()) {
            return;
        }
        int i = 0;
        Difficulty difficulty = thrower.m_9236_().m_46791_();
        if (difficulty == Difficulty.NORMAL) {
            i = 7;
        } else if (difficulty == Difficulty.HARD) {
            i = 15;
        }
        if (i > 0) {
            entityHit.m_147207_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0), thrower);
        }
    }

    public static void applyWeb(Entity thrower, BlockPos pos) {
        Level level = thrower.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!level2.m_8055_(pos).m_247087_()) {
            return;
        }
        level2.m_7731_(pos, Blocks.f_50033_.m_49966_(), 3);
        level2.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50033_.m_49966_()), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 32, 1.0, 1.0, 1.0, 1.0);
        level2.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12388_, SoundSource.HOSTILE, 1.0f, 0.5f);
        int tickDelay = DESTROY_WEB_AFTER.get(thrower);
        if (tickDelay == -1) {
            return;
        }
        ScheduledTasks.schedule((ScheduledTickTask)new TemporaryCobwebTask(tickDelay, (Level)level2, pos));
    }
}

