/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.shoot;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.skeleton.shoot.EAIRangedBowAttackGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.MinMax;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractSkeleton;

@LoadFeature(module="enhancedai:skeleton", description="Skeletons are more precise when shooting and can hit a target farther away. Only entity types in `enhancedai:skeleton/better_shooting` tag are affected by this feature")
public class SkeletonShoot
extends Feature {
    public static final TagKey<EntityType<?>> BETTER_SKELETON_SHOOT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("skeleton/better_shooting"));
    @Config(min=1.0, max=64.0, description="The range from where a skeleton will shoot a player")
    public static MinMax shootingRange = new MinMax(24.0, 32.0);
    @Config(min=0.0, description="The ticks cooldown after shooting")
    public static MinMax shootingCooldown = new MinMax(35.0, 40.0);
    @Config(min=0.0, description="The ticks the skeleton charges the bow. at least 20 ticks for a full charge.")
    public static MinMax bowChargeTicks = new MinMax(15.0, 30.0);
    @Config(min=0.0, max=1.0, description="Chance for a Skeleton to spawn with the ability to strafe (like vanilla)")
    public static Double strafeChance = 0.333;
    @Config(min=0.0, max=30.0, description="How much inaccuracy does the arrow fired by skeletons have. Vanilla skeletons have 10/6/2 inaccuracy in easy/normal/hard difficulty.")
    public static Difficulty inaccuracy = new Difficulty(6.0, 5.0, 3.0);
    public static EAIData<Integer> SHOOTING_RANGE;
    public static EAIData<Integer> SHOOTING_COOLDOWN;
    public static EAIData<Integer> BOW_CHARGE_TICKS;
    public static EAIData<Boolean> STRAFE;
    public static EAIData<Double> INACCURACY;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        SHOOTING_RANGE = EAIData.ofInt(this.createDataKey("shooting_range"));
        SHOOTING_COOLDOWN = EAIData.ofInt(this.createDataKey("shooting_cooldown"));
        BOW_CHARGE_TICKS = EAIData.ofInt(this.createDataKey("bow_charge_ticks"));
        STRAFE = EAIData.ofBool(this.createDataKey("strafe"));
        INACCURACY = EAIData.ofDouble(this.createDataKey("inaccuracy"));
    }

    public static void onReassessWeaponGoal(AbstractSkeleton skeleton) {
        if (!SkeletonShoot.isEnabled(SkeletonShoot.class) || Spawning.isUnaffectedByFeatures((Entity)skeleton) || skeleton.m_9236_().f_46443_ || !skeleton.m_6095_().m_204039_(BETTER_SKELETON_SHOOT)) {
            return;
        }
        GoalHelper.removeGoal(skeleton.f_21345_, EAIRangedBowAttackGoal.class);
        if (GoalHelper.hasGoal(skeleton.f_21345_, (Goal)skeleton.f_32130_)) {
            skeleton.f_21345_.m_25363_((Goal)skeleton.f_32130_);
            EAIRangedBowAttackGoal rangedBowAttackGoal = new EAIRangedBowAttackGoal(skeleton, 1.0, SHOOTING_COOLDOWN, INACCURACY, SHOOTING_RANGE, STRAFE, BOW_CHARGE_TICKS);
            skeleton.f_21345_.m_25352_(2, (Goal)rangedBowAttackGoal);
        }
        SHOOTING_COOLDOWN.applyIfAbsent((Mob)skeleton, shootingCooldown.getIntRandBetween(skeleton.m_217043_()));
        INACCURACY.applyIfAbsent((Mob)skeleton, inaccuracy.getByDifficulty(skeleton.m_9236_()));
        SHOOTING_RANGE.applyIfAbsent((Mob)skeleton, shootingRange.getIntRandBetween(skeleton.m_217043_()));
        STRAFE.applyIfAbsent((Mob)skeleton, skeleton.m_217043_().m_188500_() < strafeChance);
        BOW_CHARGE_TICKS.applyIfAbsent((Mob)skeleton, bowChargeTicks.getIntRandBetween(skeleton.m_217043_()));
    }
}

