/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.snowgolem;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:snow_golem", description="Snow golems snowballs freeze entities hit. Only entity types in enhancedai:snow_golem/freezing_snowballs tag are affected by this feature.")
public class SnowGolemsFreezingSnowballs
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("snow_golem/freezing_snowballs"));
    @Config(min=0.0, description="How many ticks the entity hit is frozen for.")
    public static Integer ticks = 30;
    @Config
    public static Boolean stackFreeze = true;
    public static EAIData<Integer> TICKS;
    public static EAIData<Boolean> STACK;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        TICKS = EAIData.ofInt(this.createDataKey("ticks"));
        STACK = EAIData.ofBool(this.createDataKey("stack"));
    }

    @SubscribeEvent
    public void onProjectileImpactEvent(ProjectileImpactEvent event) {
        LivingEntity entityHit;
        SnowGolem snowGolem;
        block7: {
            block6: {
                EntityHitResult entityHitResult;
                Entity entity;
                if (!this.isEnabled() || !((entity = event.getProjectile().m_19749_()) instanceof SnowGolem)) break block6;
                snowGolem = (SnowGolem)entity;
                entity = event.getRayTraceResult();
                if (!(entity instanceof EntityHitResult) || !((entity = (entityHitResult = (EntityHitResult)entity).m_82443_()) instanceof LivingEntity)) break block6;
                entityHit = (LivingEntity)entity;
                if (!(entityHitResult.m_82443_() instanceof SnowGolem)) break block7;
            }
            return;
        }
        if (!TICKS.has((Entity)snowGolem)) {
            return;
        }
        int ticks = TICKS.get((Entity)snowGolem);
        if (ticks <= 0) {
            return;
        }
        int ticksFrozen = ticks;
        if (STACK.get((Entity)snowGolem).booleanValue()) {
            ticksFrozen += entityHit.m_146888_();
        }
        entityHit.m_146917_(ticksFrozen);
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        SnowGolem snowGolem;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof SnowGolem) || !(snowGolem = (SnowGolem)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        TICKS.applyIfAbsent((Mob)snowGolem, ticks);
        STACK.applyIfAbsent((Mob)snowGolem, stackFreeze);
    }
}

