/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.darkart;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.witch.darkart.DarkArtWitchGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:witch", description="Witches summon Villagers and cast a lightning upon them. Only entity types in the `enhancedai:witch/can_perform_dark_arts` tag will be affected (can be used for any mob, not only witches).")
public class DarkArt
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("witch/can_perform_dark_arts"));
    @Config(min=0.0, max=1.0, description="Chance for a witch to get the Dark Art AI (as soon as they have a target and are less than 10 blocks away from the target will summon a Villager and cast a lightning bolt on them")
    public static Double chance = 0.333;
    @Config(min=0.0, description="At which distance from the witch will she start performing the Dark Art")
    public static Integer triggerDistance = 10;
    @Config(min=0.0, description="At which distance from the villager will the witch will cancel the summoning")
    public static Integer cancelDistance = 16;
    @Config(min=0.0)
    public static Boolean summonedWitchesCanBeDarkArt = false;
    public static ResourceLocation PERFORMING_DARK_ARTS;
    public static EAIData<Boolean> DARK_ARTS;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        PERFORMING_DARK_ARTS = this.createDataKey("performing_dark_arts");
        DARK_ARTS = EAIData.ofBool(this.createDataKey("dark_arts"), (witch, darkArt) -> {
            GoalHelper.removeGoal(witch.f_21345_, DarkArtWitchGoal.class);
            if (darkArt.booleanValue()) {
                witch.f_21345_.m_25352_(1, (Goal)new DarkArtWitchGoal((Mob)witch));
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        DARK_ARTS.applyIfAbsent(mob, mob.m_217043_().m_188500_() < chance);
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || !((livingEntity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        GoalHelper.getGoal(mob.f_21345_, DarkArtWitchGoal.class).ifPresent(DarkArtWitchGoal::forceStop);
    }
}

