/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.throwing;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.data.PotionOrMobEffect;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.witch.throwing.WitchThrowPotionGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@LoadFeature(module="enhancedai:witch", description="Witches throw potions farther, faster and more potion types. Also no longer chase player if they can't see him. Use the enhancedai:witch/better_potion_throwing entity type tag to add more witches that are affected by this feature.")
public class WitchPotionThrowing
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("witch/better_potion_throwing"));
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> badPotionsListConfig;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> goodPotionsListConfig;
    public static final List<String> badPotionsListDefault;
    public static final List<String> goodPotionsListDefault;
    public static ArrayList<PotionOrMobEffect> badPotionsList;
    public static ArrayList<PotionOrMobEffect> goodPotionsList;
    @Config(min=0.0, max=1.0, description="Chance for the potions thrown by the Witch to be lingering.")
    public static Double lingeringChance;
    @Config(min=1.0, description="Speed at which Witches throw potions (in ticks).")
    public static MinMax attackCooldown;
    @Config(min=8.0, max=64.0, description="Range at which Witches throw potions.")
    public static MinMax attackRange;
    @Config(min=0.0)
    public static Double inaccuracy;
    @Config(min=0.0, max=1.0, description="Chance for a Witch to be an apprentice. Apprentice Witches throw random potions instead of in order, and have a chance to throw a wrong (good) potion.")
    public static Double apprenticeChance;
    @Config(description="If true, witches will throw a potion of slow falling at their feet when they're falling for more than 8 blocks.")
    public static Boolean useSlowFalling;
    @Config(min=0.0, max=1.0, description="When below this health percentage Witches will throw Invisibility potions at their feet.")
    public static Double invisibilityHealthThreshold;
    public static ResourceLocation INVISIBILITY_COOLDOWN;
    public static EAIData<Double> LINGERING_CHANCE;
    public static EAIData<Integer> ATTACK_COOLDOWN;
    public static EAIData<Integer> ATTACK_RANGE;
    public static EAIData<Double> INACCURACY;
    public static EAIData<Boolean> APPRENTICE;
    public static EAIData<Boolean> USE_SLOW_FALL;
    public static EAIData<Double> INVISIBILITY_HEALTH_THRESHOLD;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        INVISIBILITY_COOLDOWN = this.createDataKey("invisibility_cooldown");
        LINGERING_CHANCE = EAIData.ofDouble(this.createDataKey("lingering_chance"));
        ATTACK_COOLDOWN = EAIData.ofInt(this.createDataKey("attack_cooldown"));
        ATTACK_RANGE = EAIData.ofInt(this.createDataKey("attack_range"));
        INACCURACY = EAIData.ofDouble(this.createDataKey("inaccuracy"));
        APPRENTICE = EAIData.ofBool(this.createDataKey("apprentice"));
        USE_SLOW_FALL = EAIData.ofBool(this.createDataKey("use_slow_fall"));
        INVISIBILITY_HEALTH_THRESHOLD = EAIData.ofDouble(this.createDataKey("invisibility_health_threshold"));
    }

    public void loadConfigOptions() {
        super.loadConfigOptions();
        badPotionsListConfig = this.getBuilder().comment("A list of potions that the witch can throw at enemies. Format is effect_id,duration,amplifier. The potions are thrown in order and witches will not throw a potion if the target has already the effect.").defineList("Bad Potions List", badPotionsListDefault, o -> o instanceof String);
        goodPotionsListConfig = this.getBuilder().comment("A list of potions that the witch can throw at allies (in raids). Format is effect_id,duration,amplifier. The potions are thrown in order and witches will not throw a potion if the target has already the effect. Witches will throw harming potions instead of healing if the target is undead.").defineList("Good Potions List", goodPotionsListDefault, o -> o instanceof String);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        badPotionsList = PotionOrMobEffect.parseList((List)badPotionsListConfig.get());
        goodPotionsList = PotionOrMobEffect.parseList((List)goodPotionsListConfig.get());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Witch witch;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Witch) || !(witch = (Witch)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        LINGERING_CHANCE.applyIfAbsent((Mob)witch, lingeringChance);
        ATTACK_COOLDOWN.applyIfAbsent((Mob)witch, attackCooldown.getIntRandBetween(witch.m_217043_()));
        ATTACK_RANGE.applyIfAbsent((Mob)witch, attackRange.getIntRandBetween(witch.m_217043_()));
        INACCURACY.applyIfAbsent((Mob)witch, inaccuracy);
        APPRENTICE.applyIfAbsent((Mob)witch, witch.m_217043_().m_188500_() < apprenticeChance);
        USE_SLOW_FALL.applyIfAbsent((Mob)witch, useSlowFalling);
        INVISIBILITY_HEALTH_THRESHOLD.applyIfAbsent((Mob)witch, invisibilityHealthThreshold);
        GoalHelper.removeGoal(witch.f_21345_, RangedAttackGoal.class);
        witch.f_21345_.m_25352_(2, (Goal)new WitchThrowPotionGoal(witch));
    }

    @SubscribeEvent
    public void onWitchTick(LivingEvent.LivingTickEvent event) {
        Witch witch;
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Witch) || !(witch = (Witch)livingEntity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES) || !witch.m_6084_() || witch.m_9236_().f_46443_ || witch.m_34161_()) {
            return;
        }
        if (WitchPotionThrowing.shouldUseSlowFalling() && witch.f_19789_ > 7.0f && !witch.m_21023_(MobEffects.f_19591_)) {
            ItemStack slowFallingStack = MCUtils.setCustomEffects((ItemStack)new ItemStack((ItemLike)Items.f_42736_), List.of(new MobEffectInstance(MobEffects.f_19591_, 300, 0)));
            witch.m_21563_().m_24946_(witch.m_20185_(), witch.m_20186_(), witch.m_20189_());
            if (!witch.m_20067_()) {
                witch.m_5496_(SoundEvents.f_12553_, 1.0f, 0.8f + witch.m_217043_().m_188501_() * 0.4f);
            }
            witch.m_9236_().m_46796_(2002, witch.m_20183_(), PotionUtils.m_43575_((ItemStack)slowFallingStack));
            List mobEffects = PotionUtils.m_43547_((ItemStack)slowFallingStack);
            for (MobEffectInstance mobEffect : mobEffects) {
                witch.m_7292_(new MobEffectInstance(mobEffect));
            }
        }
        if (!witch.m_21023_(MobEffects.f_19609_) && witch.m_20096_() && WitchPotionThrowing.canUseInvisibility(witch) && (double)witch.m_21223_() < (double)witch.m_21233_() * INVISIBILITY_HEALTH_THRESHOLD.get((Entity)witch)) {
            ThrownPotion thrownPotion = new ThrownPotion(witch.m_9236_(), (LivingEntity)witch);
            thrownPotion.m_37446_(MCUtils.setCustomEffects((ItemStack)new ItemStack((ItemLike)Items.f_42736_), List.of(new MobEffectInstance(MobEffects.f_19609_, 200))));
            thrownPotion.m_6686_(0.0, -1.0, 0.0, 0.1f, 2.0f);
            witch.m_9236_().m_7967_((Entity)thrownPotion);
            for (int i = 0; i < 5; ++i) {
                Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)witch, (int)16, (int)9);
                if (randomPos == null) continue;
                witch.m_21573_().m_26519_(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_, (double)1.1f);
                break;
            }
            ModNBTData.put((Entity)witch, (ResourceLocation)INVISIBILITY_COOLDOWN, (Object)20);
        }
    }

    public static boolean canUseInvisibility(Witch witch) {
        int cooldown = (Integer)ModNBTData.get((Entity)witch, (ResourceLocation)INVISIBILITY_COOLDOWN, Integer.class);
        if (--cooldown > 0) {
            ModNBTData.put((Entity)witch, (ResourceLocation)INVISIBILITY_COOLDOWN, (Object)cooldown);
            return false;
        }
        return true;
    }

    public static boolean shouldUseSlowFalling() {
        return WitchPotionThrowing.isEnabled(WitchPotionThrowing.class) && useSlowFalling != false;
    }

    static {
        badPotionsListDefault = List.of("minecraft:weakness", "minecraft:slowness", "minecraft:hunger,600,0", "minecraft:mining_fatigue,600,0", "minecraft:poison", "minecraft:blindness,120,0", "minecraft:harming");
        goodPotionsListDefault = List.of("minecraft:regeneration", "minecraft:swiftness", "minecraft:strength", "minecraft:invisibility", "minecraft:healing");
        lingeringChance = 0.15;
        attackCooldown = new MinMax(70.0, 90.0);
        attackRange = new MinMax(16.0, 24.0);
        inaccuracy = 1.0;
        apprenticeChance = 0.5;
        useSlowFalling = true;
        invisibilityHealthThreshold = 0.4;
    }
}

