/*
 * Decompiled with CFR 0.152.
 */
package harou.leashed_fences.mixin;

import harou.leashed_fences.api.KnotConnectionAccess;
import harou.leashed_fences.network.KnotConnectionSyncS2CPacket;
import harou.leashed_fences.util.KnotConnectionManager;
import harou.leashed_fences.util.KnotInteractionActions;
import harou.leashed_fences.util.KnotInteractionHelper;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1532;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_9691;
import net.minecraft.class_9817;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1532.class})
public abstract class LeashKnotEntityMixin
extends class_9691
implements class_9817,
KnotConnectionAccess {
    @Unique
    private class_9817.class_9818 leashData;
    @Unique
    private final KnotConnectionManager connectionManager = new KnotConnectionManager();

    public LeashKnotEntityMixin(class_1299<? extends class_1532> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public KnotConnectionManager leashedFences$getConnectionManager() {
        return this.connectionManager;
    }

    public void method_5773() {
        super.method_5773();
        class_1532 self = (class_1532)this;
        class_1937 class_19372 = self.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.method_60953()) {
                class_9817.method_60965((class_3218)serverWorld, (class_1297)((class_1532)((class_9817)self)));
            }
        }
    }

    @Nullable
    protected String method_5653() {
        class_1532 self = (class_1532)this;
        return class_1299.method_5890((class_1299)self.method_5864()).toString();
    }

    public class_9817.class_9818 method_60955() {
        return this.leashData;
    }

    public void method_60960(class_9817.class_9818 leashData) {
        this.leashData = leashData;
    }

    public class_243 method_45321(float tickProgress) {
        return new class_243(0.0, 0.2, 0.0);
    }

    public class_243 method_29919() {
        return new class_243(0.0, 0.2, 0.0);
    }

    public void method_65895() {
        class_1532 self = (class_1532)this;
        boolean hasVanillaConnections = !class_9817.method_71004((class_1297)self).isEmpty();
        boolean hasCustomConnections = this.connectionManager.hasConnections();
        if (!hasVanillaConnections && !hasCustomConnections) {
            self.method_31472();
        }
    }

    @Inject(method={"canStayAttached"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanStayAttached(CallbackInfoReturnable<Boolean> cir) {
        class_1532 self = (class_1532)this;
        boolean fenceExists = self.method_73183().method_8320(self.method_59940()).method_26164(class_3481.field_16584);
        if (!fenceExists && this.connectionManager.hasConnections()) {
            this.connectionManager.clearAllConnections(self.method_73183(), self);
            if (!self.method_73183().method_8608()) {
                KnotConnectionSyncS2CPacket.sendToTracking(self);
            }
        }
        cir.setReturnValue((Object)fenceExists);
    }

    @Inject(method={"onBreak"}, at={@At(value="HEAD")})
    private void onBreakHead(class_3218 world, class_1297 breaker, CallbackInfo ci) {
        class_1532 self = (class_1532)this;
        KnotInteractionHelper.discardCustomConnections(self, breaker);
    }

    @Inject(method={"writeCustomData"}, at={@At(value="RETURN")})
    private void onWriteCustomData(class_11372 view, CallbackInfo ci) {
        this.method_60962(view, this.leashData);
        this.connectionManager.writeToView(view);
    }

    @Inject(method={"readCustomData"}, at={@At(value="RETURN")})
    private void onReadCustomData(class_11368 view, CallbackInfo ci) {
        this.method_60967(view);
        this.connectionManager.readFromView(view);
    }

    @Inject(method={"onHeldLeashUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private void onOnHeldLeashUpdate(class_9817 heldLeashable, CallbackInfo ci) {
        class_1532 knot = (class_1532)this;
        boolean hasHeldEntities = !class_9817.method_71004((class_1297)knot).isEmpty();
        boolean isBeingLeashed = this.method_60953();
        boolean hasKnotToKnotConnections = this.connectionManager.hasConnections();
        if (!(hasHeldEntities || isBeingLeashed || hasKnotToKnotConnections)) {
            knot.method_31472();
        }
        ci.cancel();
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteract(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1532 knot = (class_1532)this;
        if (knot.method_73183().method_8608()) {
            return;
        }
        if (player.method_5998(hand).method_31574(class_1802.field_8868)) {
            return;
        }
        KnotInteractionHelper.HeldEntities held = new KnotInteractionHelper.HeldEntities((class_1297)player);
        KnotInteractionHelper.HeldEntities heldByKnot = new KnotInteractionHelper.HeldEntities((class_1297)knot);
        boolean playerHoldsThisKnot = KnotInteractionHelper.isHoldingEntity(held, (class_1297)knot);
        if (held.isEmpty()) {
            KnotConnectionAccess access;
            if (heldByKnot.hasMobs && !player.method_21823()) {
                cir.setReturnValue((Object)KnotInteractionActions.passMobsFromKnotToPlayer(player, knot));
                return;
            }
            if (KnotInteractionHelper.hasLeadItem(player)) {
                cir.setReturnValue((Object)KnotInteractionActions.connectKnotToPlayer(player, knot));
                return;
            }
            if (knot instanceof KnotConnectionAccess && (access = (KnotConnectionAccess)knot).leashedFences$getConnectionManager().hasConnections()) {
                cir.setReturnValue((Object)KnotInteractionActions.passKnotsFromKnotToPlayer(player, knot));
                return;
            }
            cir.setReturnValue((Object)class_1269.field_5811);
            return;
        }
        if (playerHoldsThisKnot) {
            cir.setReturnValue((Object)KnotInteractionActions.dropKnotToPlayerConnection(player, knot));
            return;
        }
        class_1269 result = KnotInteractionActions.passLeadsFromPlayerToKnot(player, knot, true);
        cir.setReturnValue((Object)result);
    }

    private static /* synthetic */ boolean lambda$tick$1(class_9817 l) {
        return l instanceof class_1532;
    }

    private static /* synthetic */ boolean lambda$tick$0(class_9817 l) {
        return !(l instanceof class_1532);
    }
}

