/*
 * Decompiled with CFR 0.152.
 */
package harou.leashed_fences.util;

import harou.leashed_fences.api.KnotConnectionAccess;
import harou.leashed_fences.network.KnotConnectionSyncS2CPacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1532;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_9817;

public class KnotConnectionManager {
    private static final String CONNECTIONS_NBT_KEY = "KnotConnections";
    private final Set<UUID> connectedKnotUuids = new HashSet<UUID>();

    public void checkDistance(class_1532 self) {
        List<class_1532> knots = this.getConnectedKnots(self);
        boolean snappedAny = false;
        if (self instanceof class_9817) {
            class_9817 leashableSelf = (class_9817)self;
            for (class_1532 knot : knots) {
                if (!(knot instanceof class_9817)) continue;
                class_9817 leashableKnot = (class_9817)knot;
                double d = leashableSelf.method_71001((class_1297)knot);
                if (!(d > leashableKnot.method_70989())) continue;
                snappedAny = true;
                KnotConnectionManager.removeConnection(self, knot);
                leashableKnot.method_65895();
                self.method_5706((class_3218)self.method_73183(), (class_1935)class_1802.field_8719);
                if (knot.method_31481()) continue;
                KnotConnectionSyncS2CPacket.sendToTracking(knot);
            }
            if (snappedAny) {
                if (!self.method_31481()) {
                    KnotConnectionSyncS2CPacket.sendToTracking(self);
                }
                leashableSelf.method_65895();
            }
        }
    }

    public static boolean createConnection(class_1532 knotA, class_1532 knotB) {
        if (knotA == knotB) {
            return false;
        }
        KnotConnectionManager managerA = KnotConnectionManager.getManager(knotA);
        KnotConnectionManager managerB = KnotConnectionManager.getManager(knotB);
        boolean addedA = managerA.connectedKnotUuids.add(knotB.method_5667());
        boolean addedB = managerB.connectedKnotUuids.add(knotA.method_5667());
        return addedA || addedB;
    }

    public static boolean removeConnection(class_1532 knotA, class_1532 knotB) {
        if (knotA == knotB) {
            return false;
        }
        KnotConnectionManager managerA = KnotConnectionManager.getManager(knotA);
        KnotConnectionManager managerB = KnotConnectionManager.getManager(knotB);
        boolean removedA = managerA.connectedKnotUuids.remove(knotB.method_5667());
        boolean removedB = managerB.connectedKnotUuids.remove(knotA.method_5667());
        return removedA || removedB;
    }

    public List<class_1532> getConnectedKnots(class_1532 self) {
        ArrayList<class_1532> connectedKnots = new ArrayList<class_1532>();
        Iterator<UUID> iterator = this.connectedKnotUuids.iterator();
        class_1937 world = self.method_73183();
        block0: while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            if (world instanceof class_3218) {
                class_1532 knot;
                class_3218 serverWorld = (class_3218)world;
                class_1297 entity = serverWorld.method_66347(uuid);
                if (entity instanceof class_1532 && !(knot = (class_1532)entity).method_31481()) {
                    connectedKnots.add(knot);
                    continue;
                }
                iterator.remove();
                continue;
            }
            for (class_1297 entity : world.method_8390(class_1532.class, new class_238(self.method_23317() - 50.0, self.method_23318() - 50.0, self.method_23321() - 50.0, self.method_23317() + 50.0, self.method_23318() + 50.0, self.method_23321() + 50.0), e -> e.method_5667().equals(uuid))) {
                if (!(entity instanceof class_1532)) continue;
                class_1532 knot = (class_1532)entity;
                connectedKnots.add(knot);
                continue block0;
            }
        }
        return connectedKnots;
    }

    public Set<UUID> getConnectedUuids() {
        return new HashSet<UUID>(this.connectedKnotUuids);
    }

    public void setConnectedUuids(Set<UUID> uuids) {
        this.connectedKnotUuids.clear();
        this.connectedKnotUuids.addAll(uuids);
    }

    public boolean hasConnections() {
        return !this.connectedKnotUuids.isEmpty();
    }

    public int getConnectionCount() {
        return this.connectedKnotUuids.size();
    }

    public void clearAllConnections(class_1937 world, class_1532 self) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (UUID uuid : new ArrayList<UUID>(this.connectedKnotUuids)) {
                class_9817 leashable;
                class_1297 entity = serverWorld.method_66347(uuid);
                if (!(entity instanceof class_1532)) continue;
                class_1532 knot = (class_1532)entity;
                KnotConnectionManager.getManager((class_1532)knot).connectedKnotUuids.remove(self.method_5667());
                boolean hasVanillaConnections = !class_9817.method_71004((class_1297)knot).isEmpty();
                boolean isBeingLeashed = knot instanceof class_9817 && (leashable = (class_9817)knot).method_60955() != null && leashable.method_60955().field_52217 != null;
                boolean hasCustomConnections = KnotConnectionManager.getManager(knot).hasConnections();
                if (!(hasVanillaConnections || isBeingLeashed || hasCustomConnections)) {
                    KnotConnectionSyncS2CPacket.sendToTracking(knot);
                    knot.method_31472();
                    continue;
                }
                KnotConnectionSyncS2CPacket.sendToTracking(knot);
            }
        }
        this.connectedKnotUuids.clear();
    }

    public void writeToView(class_11372 view) {
        if (!this.connectedKnotUuids.isEmpty()) {
            view.method_71468(CONNECTIONS_NBT_KEY, class_4844.field_47491, this.connectedKnotUuids);
        }
    }

    public void readFromView(class_11368 view) {
        this.connectedKnotUuids.clear();
        view.method_71426(CONNECTIONS_NBT_KEY, class_4844.field_47491).ifPresent(this.connectedKnotUuids::addAll);
    }

    public void writeToNbt(class_2487 nbt) {
        if (!this.connectedKnotUuids.isEmpty()) {
            class_2499 list = new class_2499();
            for (UUID uuid : this.connectedKnotUuids) {
                int[] intArray = class_4844.method_26275((UUID)uuid);
                list.add((Object)new class_2495(intArray));
            }
            nbt.method_10566(CONNECTIONS_NBT_KEY, (class_2520)list);
        }
    }

    public void readFromNbt(class_2487 nbt) {
        this.connectedKnotUuids.clear();
        Optional optList = nbt.method_10554(CONNECTIONS_NBT_KEY);
        if (optList.isPresent()) {
            class_2499 list = (class_2499)optList.get();
            for (int i = 0; i < list.size(); ++i) {
                Optional optArray = list.method_36111(i);
                if (!optArray.isPresent()) continue;
                UUID uuid = class_4844.method_26276((int[])((int[])optArray.get()));
                this.connectedKnotUuids.add(uuid);
            }
        }
    }

    public static KnotConnectionManager getManager(class_1532 knot) {
        if (knot instanceof KnotConnectionAccess) {
            KnotConnectionAccess access = (KnotConnectionAccess)knot;
            return access.leashedFences$getConnectionManager();
        }
        throw new IllegalStateException("LeashKnotEntity does not implement KnotConnectionAccess!");
    }
}

