/*
 * Decompiled with CFR 0.152.
 */
package harou.leashed_fences.util;

import harou.leashed_fences.api.KnotConnectionAccess;
import harou.leashed_fences.network.KnotConnectionSyncS2CPacket;
import harou.leashed_fences.util.KnotConnectionManager;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1532;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1804;
import net.minecraft.class_1935;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9817;

public class KnotInteractionHelper {
    public static boolean hasLeadItem(class_1657 player) {
        return player.method_6047().method_7909() instanceof class_1804 || player.method_6079().method_7909() instanceof class_1804;
    }

    public static boolean hasLeadItem(class_1657 player, class_1268 hand) {
        return player.method_5998(hand).method_7909() instanceof class_1804;
    }

    public static void consumeLead(class_1657 player) {
        if (player.method_31549().field_7477) {
            return;
        }
        if (player.method_6047().method_7909() instanceof class_1804) {
            player.method_6047().method_7934(1);
        } else if (player.method_6079().method_7909() instanceof class_1804) {
            player.method_6079().method_7934(1);
        }
    }

    public static void consumeLead(class_1657 player, class_1268 hand) {
        if (!player.method_31549().field_7477) {
            player.method_5998(hand).method_7934(1);
        }
    }

    public static boolean shouldRemoveKnot(class_1532 knot) {
        boolean hasVanillaConnections = !class_9817.method_71004((class_1297)knot).isEmpty();
        boolean isBeingLeashed = false;
        if (knot instanceof class_9817) {
            class_9817 leashable = (class_9817)knot;
            class_9817.class_9818 data = leashable.method_60955();
            isBeingLeashed = data != null && data.field_52217 != null;
        }
        boolean hasCustomConnections = false;
        if (knot instanceof KnotConnectionAccess) {
            KnotConnectionAccess access = (KnotConnectionAccess)knot;
            hasCustomConnections = access.leashedFences$getConnectionManager().hasConnections();
        }
        return !hasVanillaConnections && !isBeingLeashed && !hasCustomConnections;
    }

    public static boolean createCustomConnections(HeldEntities held, class_1532 targetKnot, class_1657 player) {
        boolean createdConnection = false;
        for (class_1532 heldKnot : held.knots) {
            if (KnotConnectionManager.createConnection(heldKnot, targetKnot)) {
                createdConnection = true;
                ((class_9817)heldKnot).method_65894();
                KnotConnectionSyncS2CPacket.sendToTracking(heldKnot);
                continue;
            }
            ((class_9817)heldKnot).method_5932();
        }
        if (createdConnection) {
            KnotConnectionSyncS2CPacket.sendToTracking(targetKnot);
            return true;
        }
        return false;
    }

    public static boolean createVanillaConnections(HeldEntities held, class_1532 targetKnot, class_1657 player) {
        boolean createdConnection = false;
        for (class_9817 heldLeashable : held.mobs) {
            if (!heldLeashable.method_71002((class_1297)targetKnot)) continue;
            heldLeashable.method_60964((class_1297)targetKnot, true);
            createdConnection = true;
        }
        return createdConnection;
    }

    public static boolean isHoldingEntity(HeldEntities held, class_1297 entity) {
        for (class_9817 leashable : held.all) {
            class_1297 e;
            if (!(leashable instanceof class_1297) || (e = (class_1297)leashable) != entity) continue;
            return true;
        }
        return false;
    }

    public static void removeKnotIfEmpty(class_1532 knot) {
        if (KnotInteractionHelper.shouldRemoveKnot(knot)) {
            knot.method_31472();
        }
    }

    public static boolean discardCustomConnections(class_1532 knot, class_1297 player) {
        class_1532 connectedKnot2;
        if (!(knot instanceof KnotConnectionAccess)) {
            return false;
        }
        KnotConnectionAccess access = (KnotConnectionAccess)knot;
        KnotConnectionManager manager = access.leashedFences$getConnectionManager();
        List<class_1532> connectedKnots = manager.getConnectedKnots(knot);
        int connectionCount = connectedKnots.size();
        for (class_1532 connectedKnot2 : connectedKnots) {
            KnotConnectionManager.removeConnection(knot, connectedKnot2);
            KnotInteractionHelper.removeKnotIfEmpty(connectedKnot2);
            KnotConnectionSyncS2CPacket.sendToTracking(connectedKnot2);
        }
        KnotInteractionHelper.removeKnotIfEmpty(knot);
        if (!knot.method_31481()) {
            KnotConnectionSyncS2CPacket.sendToTracking(knot);
        }
        if ((connectedKnot2 = knot.method_73183()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)connectedKnot2;
            for (int i = 0; i < connectionCount; ++i) {
                knot.method_5699(serverWorld, new class_1799((class_1935)class_1802.field_8719), 0.0f);
            }
        }
        knot.method_32875((class_6880)class_5712.field_28173, player);
        return connectionCount > 0;
    }

    public static boolean pickupCustomConnections(class_1532 knot, class_1297 player) {
        if (!(knot instanceof KnotConnectionAccess)) {
            return false;
        }
        KnotConnectionAccess access = (KnotConnectionAccess)knot;
        KnotConnectionManager manager = access.leashedFences$getConnectionManager();
        List<class_1532> connectedKnots = manager.getConnectedKnots(knot);
        for (class_1532 connectedKnot : connectedKnots) {
            KnotConnectionManager.removeConnection(knot, connectedKnot);
            double distance = player.method_5858((class_1297)connectedKnot);
            if (distance <= 100.0) {
                ((class_9817)connectedKnot).method_60964(player, true);
            }
            KnotConnectionSyncS2CPacket.sendToTracking(connectedKnot);
        }
        KnotInteractionHelper.removeKnotIfEmpty(knot);
        if (!knot.method_31481()) {
            KnotConnectionSyncS2CPacket.sendToTracking(knot);
        }
        knot.method_32875((class_6880)class_5712.field_28173, player);
        return connectedKnots.size() > 0;
    }

    public static class HeldEntities {
        public final List<class_9817> all;
        public final List<class_9817> mobs;
        public final List<class_1532> knots;
        public final boolean hasMobs;
        public final boolean hasKnots;

        public HeldEntities(class_1297 entity) {
            this.all = class_9817.method_71004((class_1297)entity);
            this.mobs = this.all.stream().filter(l -> !(l instanceof class_1532)).toList();
            this.knots = this.all.stream().filter(l -> l instanceof class_1532).map(l -> (class_1532)l).toList();
            this.hasMobs = !this.mobs.isEmpty();
            this.hasKnots = !this.knots.isEmpty();
        }

        public boolean isEmpty() {
            return this.all.isEmpty();
        }
    }
}

