/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.farmersdelightpatch.impl.res;

import eu.pb4.farmersdelightpatch.impl.polydex.PolydexTextures;
import eu.pb4.farmersdelightpatch.impl.res.UiResourceCreator;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9334;

public class GuiTextures {
    public static final Function<class_2561, class_2561> COOKING_POT = UiResourceCreator.background("cooking_pot");
    public static final Supplier<GuiElementBuilder> EMPTY_BUILDER = UiResourceCreator.icon16("empty");
    public static final Supplier<GuiElementBuilder> HEATED = UiResourceCreator.icon16("heated");
    public static final GuiElement EMPTY = EMPTY_BUILDER.get().hideTooltip().build();
    public static final Supplier<GuiElementBuilder> POLYDEX_BUTTON = UiResourceCreator.icon32("polydex");
    public static final Progress PROGRESS_COOKING_POT = Progress.createHorizontal32Right("progress_cooking_pot", 4, 26, false);
    public static final char SPACE_1 = UiResourceCreator.space(1);
    public static final char POLYDEX_OFFSET = UiResourceCreator.space(168);
    public static final char POLYDEX_OFFSET_N = UiResourceCreator.space(-168);

    public static void register() {
        PolydexTextures.register();
    }

    public record Progress(GuiElement[] elements, class_1799[] withTooltip) {
        public GuiElement get(float progress) {
            return this.elements[Math.min((int)(progress * (float)this.elements.length), this.elements.length - 1)];
        }

        public GuiElement getCeil(float progress) {
            return this.elements[Math.min((int)Math.ceil(progress * (float)this.elements.length), this.elements.length - 1)];
        }

        public class_1799 getNamed(float progress, class_2561 text) {
            class_1799 base = this.withTooltip[Math.min((int)(progress * (float)this.withTooltip.length), this.withTooltip.length - 1)].method_7972();
            base.method_57379(class_9334.field_50239, (Object)text);
            return base;
        }

        private static Progress create(int size, IntFunction<GuiElementBuilder> function) {
            GuiElement[] elements = new GuiElement[size + 1];
            class_1799[] withTooltip = new class_1799[size + 1];
            elements[0] = EMPTY;
            withTooltip[0] = EMPTY.getItemStack().method_7972();
            for (int i = 1; i <= size; ++i) {
                elements[i] = function.apply(i - 1).hideTooltip().build();
                withTooltip[i] = function.apply(i - 1).asStack();
            }
            return new Progress(elements, withTooltip);
        }

        public static Progress createVertical(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.verticalProgress16(path, start, stop, reverse);
            return Progress.create(size, function);
        }

        public static Progress createHorizontal(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress16(path, start, stop, reverse, 0);
            return Progress.create(size, function);
        }

        public static Progress createHorizontal(String path, int start, int stop, boolean reverse, int offset) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress16(path, start, stop, reverse, offset);
            return Progress.create(size, function);
        }

        public static Progress createHorizontal32(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress32(path, start, stop, reverse);
            return Progress.create(size, function);
        }

        public static Progress createHorizontal32Right(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress32Right(path, start, stop, reverse);
            return Progress.create(size, function);
        }

        public static Progress createVertical32Right(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.verticalProgress32Right(path, start, stop, reverse);
            return Progress.create(size, function);
        }
    }
}

