/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.farmersdelightpatch.impl.res;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.farmersdelightpatch.impl.FarmersDelightPolymerPatch;
import eu.pb4.farmersdelightpatch.impl.res.ResourceUtils;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class UiResourceCreator {
    public static final String BASE_MODEL = "minecraft:item/generated";
    public static final String X32_MODEL = "farmers-delight-patch:sgui/button_32";
    public static final String X32_RIGHT_MODEL = "farmers-delight-patch:sgui/button_32_right";
    public static final class_2583 STYLE = class_2583.field_24360.method_36139(0xFFFFFF).method_27704(FarmersDelightPolymerPatch.id("gui"));
    private static final String ITEM_TEMPLATE = "{\n  \"parent\": \"|BASE|\",\n  \"textures\": {\n    \"layer0\": \"|ID|\"\n  }\n}\n".replace(" ", "").replace("\n", "");
    private static final String ITEM_TEMPLATE_OFFSET = "{\n  \"parent\": \"|BASE|\",\n  \"textures\": {\n    \"layer0\": \"|ID|\"\n  },\n  \"display\": {\n      \"gui\": {\n        \"rotation\": [ 0, 0, 0 ],\n        \"translation\": [ |OFFSET|, 0, 0 ],\n        \"scale\": [ 1, 1, 1 ]\n      }\n    }\n}\n".replace(" ", "").replace("\n", "");
    private static final List<SlicedTexture> VERTICAL_PROGRESS = new ArrayList<SlicedTexture>();
    private static final List<SlicedTexture> HORIZONTAL_PROGRESS = new ArrayList<SlicedTexture>();
    private static final List<SimpleModel> SIMPLE_MODEL = new ArrayList<SimpleModel>();
    private static final Char2IntMap SPACES = new Char2IntOpenHashMap();
    private static final List<FontTexture> FONT_TEXTURES = new ArrayList<FontTexture>();
    private static char character;
    private static final char CHEST_SPACE0;
    private static final char CHEST_SPACE1;
    private static final char ANVIL_SPACE0;
    private static final char ANVIL_SPACE1;

    public static Supplier<GuiElementBuilder> icon16(String path) {
        class_1799 model = UiResourceCreator.genericIconRaw(class_1802.field_17500, path, BASE_MODEL, 0);
        return () -> new GuiElementBuilder(model).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip();
    }

    public static Supplier<GuiElementBuilder> icon16Offset(String path, int offset) {
        class_1799 model = UiResourceCreator.genericIconRaw(class_1802.field_17500, path, BASE_MODEL, offset);
        return () -> new GuiElementBuilder(model).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip();
    }

    public static Supplier<GuiElementBuilder> icon32(String path) {
        class_1799 model = UiResourceCreator.genericIconRaw(class_1802.field_17500, path, X32_MODEL, 0);
        return () -> new GuiElementBuilder(model).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip();
    }

    public static IntFunction<GuiElementBuilder> icon32Color(String path) {
        class_1799 model = UiResourceCreator.genericIconRaw(class_1802.field_8570, path, X32_MODEL, 0);
        return i -> new GuiElementBuilder(model).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip().setComponent(class_9334.field_49644, (Object)new class_9282(i));
    }

    public static IntFunction<GuiElementBuilder> icon16(String path, int size) {
        class_1799[] models = new class_1799[size];
        for (int i2 = 0; i2 < size; ++i2) {
            models[i2] = UiResourceCreator.genericIconRaw(class_1802.field_17500, path + "_" + i2, BASE_MODEL, 0);
        }
        return i -> new GuiElementBuilder(models[i]).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip();
    }

    public static IntFunction<GuiElementBuilder> horizontalProgress16(String path, int start, int stop, boolean reverse, int offset) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, BASE_MODEL, HORIZONTAL_PROGRESS, offset);
    }

    public static IntFunction<GuiElementBuilder> horizontalProgress32(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_MODEL, HORIZONTAL_PROGRESS, 0);
    }

    public static IntFunction<GuiElementBuilder> horizontalProgress32Right(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_RIGHT_MODEL, HORIZONTAL_PROGRESS, 0);
    }

    public static IntFunction<GuiElementBuilder> verticalProgress32(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_MODEL, VERTICAL_PROGRESS, 0);
    }

    public static IntFunction<GuiElementBuilder> verticalProgress32Right(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_RIGHT_MODEL, VERTICAL_PROGRESS, 0);
    }

    public static IntFunction<GuiElementBuilder> verticalProgress16(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, BASE_MODEL, VERTICAL_PROGRESS, 0);
    }

    public static IntFunction<GuiElementBuilder> genericProgress(String path, int start, int stop, boolean reverse, String base, List<SlicedTexture> progressType, int offset) {
        class_1799[] models = new class_1799[stop - start];
        progressType.add(new SlicedTexture(path, start, stop, reverse));
        for (int i2 = start; i2 < stop; ++i2) {
            models[i2 - start] = UiResourceCreator.genericIconRaw(class_1802.field_17500, "gen/" + path + "_" + i2, base, offset);
        }
        return i -> new GuiElementBuilder(models[i]).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip();
    }

    public static class_1799 genericIconRaw(class_1792 item, String path, String base, int offset) {
        Object extra = offset == 0 ? "" : "_offset_" + offset;
        class_2960 texturePath = UiResourceCreator.elementPath(path);
        class_2960 modelPath = UiResourceCreator.elementPath(path + (String)extra);
        SIMPLE_MODEL.add(new SimpleModel(texturePath, modelPath, base, offset));
        return ItemDisplayElementUtil.getModel((class_2960)texturePath);
    }

    private static class_2960 elementPath(String path) {
        return FarmersDelightPolymerPatch.id("sgui/elements/" + path);
    }

    public static Function<class_2561, class_2561> background(String path) {
        StringBuilder builder = new StringBuilder().append(CHEST_SPACE0);
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        builder.append(c2);
        builder.append(CHEST_SPACE1);
        FontTexture texture = new FontTexture(FarmersDelightPolymerPatch.id("sgui/" + path), 13, 256, new char[][]{{c2}});
        FONT_TEXTURES.add(texture);
        return new TextBuilders((class_2561)class_2561.method_43470((String)builder.toString()).method_10862(STYLE));
    }

    public static Function<class_2561, class_2561> backgroundAnvil(String path) {
        StringBuilder builder = new StringBuilder().append(ANVIL_SPACE0);
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        builder.append(c2);
        builder.append(ANVIL_SPACE1);
        FontTexture texture = new FontTexture(FarmersDelightPolymerPatch.id("sgui/" + path), 13, 256, new char[][]{{c2}});
        FONT_TEXTURES.add(texture);
        return new TextBuilders((class_2561)class_2561.method_43470((String)builder.toString()).method_10862(STYLE));
    }

    public static char font(class_2960 path, int ascent, int height) {
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        FontTexture texture = new FontTexture(path, ascent, height, new char[][]{{c2}});
        FONT_TEXTURES.add(texture);
        return c2;
    }

    public static class_3545<class_2561, class_2561> polydexBackground(String path) {
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        char c3 = character;
        character = (char)(c3 + '\u0001');
        char d = c3;
        FontTexture texture = new FontTexture(FarmersDelightPolymerPatch.id("sgui/polydex/" + path), -4, 128, new char[][]{{c2}, {d}});
        FONT_TEXTURES.add(texture);
        return new class_3545((Object)class_2561.method_43470((String)Character.toString(c2)).method_10862(STYLE), (Object)class_2561.method_43470((String)Character.toString(d)).method_10862(STYLE));
    }

    public static char space(int width) {
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        SPACES.put(c2, width);
        return c2;
    }

    public static void setup() {
        SPACES.put(CHEST_SPACE0, -8);
        SPACES.put(CHEST_SPACE1, -168);
        SPACES.put(ANVIL_SPACE0, -60);
        SPACES.put(ANVIL_SPACE1, -119);
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(b -> UiResourceCreator.generateAssets((arg_0, arg_1) -> ((ResourcePackBuilder)b).addData(arg_0, arg_1)));
    }

    private static void generateProgress(BiConsumer<String, byte[]> assetWriter, List<SlicedTexture> list, boolean horizontal) {
        for (SlicedTexture pair : list) {
            BufferedImage sourceImage = ResourceUtils.getTexture(UiResourceCreator.elementPath(pair.path()));
            BufferedImage image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
            int xw = horizontal ? image.getHeight() : image.getWidth();
            int mult = pair.reverse ? -1 : 1;
            int offset = pair.reverse ? pair.stop + pair.start - 1 : 0;
            for (int y = pair.start; y < pair.stop; ++y) {
                class_2960 path = UiResourceCreator.elementPath("gen/" + pair.path + "_" + y);
                int pos = offset + y * mult;
                for (int x = 0; x < xw; ++x) {
                    if (horizontal) {
                        image.setRGB(pos, x, sourceImage.getRGB(pos, x));
                        continue;
                    }
                    image.setRGB(x, pos, sourceImage.getRGB(x, pos));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                assetWriter.accept(AssetPaths.texture((String)path.method_12836(), (String)(path.method_12832() + ".png")), out.toByteArray());
            }
        }
    }

    public static void generateAssets(BiConsumer<String, byte[]> assetWriter) {
        for (SimpleModel texture : SIMPLE_MODEL) {
            if (texture.offset == 0) {
                assetWriter.accept("assets/" + texture.modelPath.method_12836() + "/models/" + texture.modelPath.method_12832() + ".json", ITEM_TEMPLATE.replace("|ID|", texture.texturePath.toString()).replace("|BASE|", texture.base).getBytes(StandardCharsets.UTF_8));
                continue;
            }
            assetWriter.accept("assets/" + texture.modelPath.method_12836() + "/models/" + texture.modelPath.method_12832() + ".json", ITEM_TEMPLATE_OFFSET.replace("|ID|", texture.texturePath.toString()).replace("|BASE|", texture.base).replace("|OFFSET|", "" + texture.offset).getBytes(StandardCharsets.UTF_8));
        }
        UiResourceCreator.generateProgress(assetWriter, VERTICAL_PROGRESS, false);
        UiResourceCreator.generateProgress(assetWriter, HORIZONTAL_PROGRESS, true);
        JsonObject fontBase = new JsonObject();
        JsonArray providers = new JsonArray();
        JsonObject spaces = new JsonObject();
        spaces.addProperty("type", "space");
        JsonObject advances = new JsonObject();
        SPACES.char2IntEntrySet().stream().sorted(Comparator.comparing(Char2IntMap.Entry::getCharKey)).forEach(c -> advances.addProperty(Character.toString(c.getCharKey()), (Number)c.getIntValue()));
        spaces.add("advances", (JsonElement)advances);
        providers.add((JsonElement)spaces);
        FONT_TEXTURES.forEach(entry -> {
            JsonObject bitmap = new JsonObject();
            bitmap.addProperty("type", "bitmap");
            bitmap.addProperty("file", String.valueOf(entry.path) + ".png");
            bitmap.addProperty("ascent", (Number)entry.ascent);
            bitmap.addProperty("height", (Number)entry.height);
            JsonArray chars = new JsonArray();
            for (char[] a : entry.chars) {
                StringBuilder builder = new StringBuilder();
                for (char b : a) {
                    builder.append(b);
                }
                chars.add(builder.toString());
            }
            bitmap.add("chars", (JsonElement)chars);
            providers.add((JsonElement)bitmap);
        });
        fontBase.add("providers", (JsonElement)providers);
        assetWriter.accept("assets/farmers-delight-patch/font/gui.json", fontBase.toString().getBytes(StandardCharsets.UTF_8));
    }

    static {
        char c = character = (char)97;
        character = (char)(c + '\u0001');
        CHEST_SPACE0 = c;
        char c2 = character;
        character = (char)(c2 + '\u0001');
        CHEST_SPACE1 = c2;
        char c3 = character;
        character = (char)(c3 + '\u0001');
        ANVIL_SPACE0 = c3;
        char c4 = character;
        character = (char)(c4 + '\u0001');
        ANVIL_SPACE1 = c4;
    }

    public record SlicedTexture(String path, int start, int stop, boolean reverse) {
    }

    public record SimpleModel(class_2960 texturePath, class_2960 modelPath, String base, int offset) {
    }

    public record FontTexture(class_2960 path, int ascent, int height, char[][] chars) {
    }

    private record TextBuilders(class_2561 base) implements Function<class_2561, class_2561>
    {
        @Override
        public class_2561 apply(class_2561 text) {
            return class_2561.method_43473().method_10852(this.base).method_10852(text);
        }
    }
}

