package cn.mmf.energyblade;

import cn.mmf.energyblade.energy.FEBladeStorage;
import cn.sh1rocu.sfaddons.util.ItemEnergyStorageHelper;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1799;
import net.minecraft.class_2398;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class PowerSwitchPacket {
    public static final class_2960 ID = new class_2960(Energyblade.MODID, "power_switch");

    public static void toBytes(class_2540 buf, String message) {
        buf.method_10814(message);
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 context, class_2540 buf, PacketSender packetSender) {
        String message = buf.method_10800(Short.MAX_VALUE);
        server.execute(() -> {
            if (player.method_7325())
                return;

            class_1799 mainHandItem = player.method_6047();
            if (CapabilitySlashBlade.BLADESTATE.maybeGet(mainHandItem).isEmpty())
                return;

            ItemEnergyStorageHelper.fromStack(mainHandItem).ifPresent(energy -> {
                if (energy instanceof FEBladeStorage bladeFE) {
                    try (Transaction tx = Transaction.openOuter()) {
                        if (!bladeFE.isPowered() && bladeFE.extract(bladeFE.getPowerupExtract(), tx) == bladeFE.getPowerupExtract()) {
                            bladeFE.setPowered(true);
                            class_3218 serverLevel = player.method_51469();
                            var random = serverLevel.field_9229;
                            for (int i = 0; i < 32; ++i) {
                                double xDist = (random.method_43057() * 2.0F - 1.0F);
                                double yDist = (random.method_43057() * 2.0F - 1.0F);
                                double zDist = (random.method_43057() * 2.0F - 1.0F);
                                if (!(xDist * xDist + yDist * yDist + zDist * zDist > 1.0D)) {
                                    double x = player.method_23316(xDist / 4.0D);
                                    double y = player.method_23323(0.5D + yDist / 4.0D);
                                    double z = player.method_23324(zDist / 4.0D);
                                    serverLevel.method_14199(class_2398.field_11214, x, y, z, 0, xDist, yDist + 0.2D, zDist,
                                            1);
                                }
                            }
                            player.method_17356(class_3417.field_14896, class_3419.field_15248, 2.5F, 1F);
                            tx.commit();
                        } else {
                            bladeFE.setPowered(false);
                            mainHandItem.method_7911("bladeState").method_10562("Energy").method_10556("isPowered", false);
                            player.method_17356(class_3417.field_14627, class_3419.field_15248, 1F, 1F);
                        }
                    }
                }
            });
        });
    }

}
