package cn.mmf.energyblade.item;

import cn.mmf.energyblade.client.render.EnergyBladeBEWLR;
import cn.mmf.energyblade.energy.FEBladeStorage;
import cn.mmf.energyblade.energy.FECapabilityProvider;
import cn.sh1rocu.sfaddons.api.extension.IDamageable;
import cn.sh1rocu.sfaddons.util.ItemEnergyStorageHelper;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_756;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import team.reborn.energy.api.EnergyStorage;

import java.util.List;
import java.util.function.Consumer;

// 拓展子类拔刀剑(extends ItemSlashBlade)
public class ItemFEBlade extends ItemSlashBlade implements IDamageable {

    public ItemFEBlade(class_1832 tier, int attackDamageIn, float attackSpeedIn, class_1793 builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        EnergyStorage.ITEM.registerForItems((stack, context) -> {
            var bladeState = stack.method_7911("bladeState");
            if (bladeState.method_10545("Energy")) {
                var tag = bladeState.method_10562("Energy");
                long energy = tag.method_10537("Energy");
                long capacity = tag.method_10537("Capacity");
                long maxReceive = tag.method_10537("MaxReceive");
                long maxExtract = tag.method_10537("MaxExtract");
                long powerupExtract = tag.method_10537("PowerupExtract");
                long standbyExtract = tag.method_10537("StandbyExtract");
                boolean energyDurability = tag.method_10577("EnergyDurability");
                boolean isPowered = tag.method_10577("isPowered");
                FEBladeStorage storage = new FEBladeStorage(energy, capacity, powerupExtract, standbyExtract, energyDurability) {
                    @Override
                    protected void onFinalCommit() {
                        super.onFinalCommit();
                        bladeState.method_10566("Energy", serializeNBT());
                    }
                };
                storage.setMaxReceive(maxReceive);
                storage.setMaxExtract(maxExtract);
                storage.setPowered(isPowered);
                return storage;
            } else {
                FEBladeStorage storage = new FEBladeStorage(0, 2000000, 1000, 100, false) {
                    @Override
                    protected void onFinalCommit() {
                        super.onFinalCommit();
                        bladeState.method_10566("Energy", serializeNBT());
                    }
                };
                bladeState.method_10566("Energy", storage.serializeNBT());
                return storage;
            }
        }, this);
    }

    @Override
    public boolean isDamageable(class_1799 stack) {
        return ItemEnergyStorageHelper.fromStack(stack).filter(FEBladeStorage.class::isInstance)
                .map(FEBladeStorage.class::cast).filter(FEBladeStorage::isEnergyDurability) // 当启用能量代替耐久时
                .map(energy -> false) // 禁用原版耐久机制
                .orElseGet(() -> IDamageable.super.isDamageable(stack)); // 否则继承默认逻辑
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        this.appendForgeEnergyInfo(stack, tooltip);
    }

    // 能量显示
    @Environment(EnvType.CLIENT)
    public void appendForgeEnergyInfo(class_1799 stack, List<class_2561> tooltip) {
        ItemEnergyStorageHelper.fromStack(stack).ifPresent(energy -> {
            class_310 mc = class_310.method_1551();
            class_304 shift = mc.field_1690.field_1832;
            if (!isShiftKeyDown()) {
                // 动态实时显示具体按键
                class_2561 shiftKey = class_2561.method_43470("[").method_10852(shift.method_16007().method_27661())
                        .method_27693("]").method_27692(class_124.field_1065);
                tooltip.add(class_2561.method_43469("tip.slashblade_fabric_addons.energyblade.energy_info", shiftKey)
                        .method_27692(class_124.field_1080));
            } else {
                class_2561 energyTip = class_2561
                        .method_43470(energy.getAmount() + " / " + energy.getCapacity())
                        .method_27692(class_124.field_1065);
                tooltip.add(class_2561.method_43469("tip.slashblade_fabric_addons.energyblade.forge_energy_info", energyTip)
                        .method_27692(class_124.field_1080));
            }
        });
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        return ItemEnergyStorageHelper.fromStack(stack).filter(FEBladeStorage.class::isInstance)
                .map(FEBladeStorage.class::cast)
                .map(energy ->
                        isShiftKeyDown() || energy.isPowered()
                )
                .orElse(false);
    }

    @Override
    public int method_31569(class_1799 stack) {
        return ItemEnergyStorageHelper.fromStack(stack).filter(FEBladeStorage.class::isInstance)
                .map(FEBladeStorage.class::cast)
                .filter(energy -> energy.getCapacity() > 0) // 防止除以零
                .map(energy -> {
                    double ratio = (double) energy.getAmount() / energy.getCapacity();
                    return (int) (ratio * field_30889);
                }).orElse(0); // 无能量存储时返回0
    }

    @Override
    public int method_31571(class_1799 stack) {
        return 0xFFAA00; // 金色能量条，避免与原本耐久条混淆
    }

    // 覆写该方法用以修改拔刀剑渲染(具体参考EnergyBladeBEWLR类)
    @Environment(EnvType.CLIENT)
    @Override
    public class_756 getCustomRenderer() {
        class_756 renderer = new EnergyBladeBEWLR(
                class_310.method_1551().method_31975(),
                class_310.method_1551().method_31974());
        return renderer;
    }

    @Override
    public SlashBladeState initCapability(class_1799 stack) {
        return new FECapabilityProvider(stack, ItemEnergyStorageHelper.fromStack(stack).orElse(null));
    }

    @Override
    public <T extends class_1309> int damageItem(class_1799 arg0, int arg1, T arg2, Consumer<T> arg3) {
        // TODO 电量耐久适配消耗
        return super.damageItem(arg0, arg1, arg2, arg3);
    }

    @Environment(EnvType.CLIENT)
    private boolean isShiftKeyDown() {
        class_310 mc = class_310.method_1551();
        class_304 shift = mc.field_1690.field_1832;
        class_3675.class_306 key = shift.field_1655;
        long window = mc.method_22683().method_4490();
        if (key.method_1442() == class_3675.class_307.field_1668) {
            return GLFW.glfwGetKey(window, key.method_1444()) == GLFW.GLFW_PRESS;
        } else if (key.method_1442() == class_3675.class_307.field_1672) {
            return GLFW.glfwGetMouseButton(window, key.method_1444()) == GLFW.GLFW_PRESS;
        }
        return false;
    }

    public static void onSlashBladeUpdate(SlashBladeEvent.UpdateEvent event) {
        if (!(event.getEntity() instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309) event.getEntity();
        if (!event.isSelected()) {
            return;
        }

        ItemEnergyStorageHelper.fromStack(event.getBlade()).ifPresent(energy -> {
            if (energy instanceof FEBladeStorage bladeFE) {
                if (bladeFE.isPowered()) {
                    try (Transaction tx = Transaction.openOuter()) {
                        if (bladeFE.extract(bladeFE.getStandbyExtract(), tx) == bladeFE.getStandbyExtract()) {
                            CapabilityConcentrationRank.RANK_POINT.maybeGet(living)
                                    .ifPresent(cap -> cap.addRankPoint(living, cap.getMaxCapacity()));
                            tx.commit();
                        } else {
                            bladeFE.setPowered(false);
                            event.getBlade().method_7911("bladeState").method_10562("Energy").method_10556("isPowered", false);
                            event.getEntity().method_5783(class_3417.field_14627, 1F, 1F);
                        }
                    }
                }
            }
        });
    }

    public static void onSlashBladeHit(SlashBladeEvent.HitEvent event) {
        ItemEnergyStorageHelper.fromStack(event.getBlade()).ifPresent(energy -> {
            if (energy instanceof FEBladeStorage bladeFE) {
                if (bladeFE.isPowered()) {
                    try (Transaction tx = Transaction.openOuter()) {
                        if (bladeFE.extract(bladeFE.getStandbyExtract(), tx) == bladeFE.getStandbyExtract()) {
                            tx.commit();
                        } else {
                            bladeFE.setPowered(false);
                            event.getBlade().method_7911("bladeState").method_10562("Energy").method_10556("isPowered", false);
                            event.getUser().method_5783(class_3417.field_14627, 1F, 1F);
                        }
                    }
                }
            }
        });
    }

    public static void onSlashBladePowered(SlashBladeEvent.PowerBladeEvent event) {
        ItemEnergyStorageHelper.fromStack(event.getBlade()).ifPresent(energy -> {
            if (energy instanceof FEBladeStorage bladeFE) {
                if (bladeFE.isPowered()) {
                    event.setPowered(true);
                }
            }
        });
    }
}
