/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7655;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public abstract class AbstractConditionalDatapackEntriesProvider
implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_7784 output;
    private final CompletableFuture<class_7225.class_7874> registries;
    private final Predicate<String> namespacePredicate;
    private static final List<class_7655.class_7657<?>> DATA_PACK_REGISTRIES = new ArrayList(class_7655.field_39968);
    private static final List<class_7655.class_7657<?>> DATA_PACK_REGISTRIES_VIEW = Collections.unmodifiableList(DATA_PACK_REGISTRIES);

    public AbstractConditionalDatapackEntriesProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries, Set<String> modIds) {
        Predicate<Object> predicate;
        if (modIds == null) {
            predicate = namespace -> true;
        } else {
            Objects.requireNonNull(modIds);
            predicate = modIds::contains;
        }
        this.namespacePredicate = predicate;
        this.registries = registries;
        this.output = output;
    }

    public AbstractConditionalDatapackEntriesProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries, class_7877 datapackEntriesBuilder, Set<String> modIds) {
        this(output, (CompletableFuture<class_7225.class_7874>)registries.thenApply(r -> AbstractConditionalDatapackEntriesProvider.constructDatapackRegistries(r, datapackEntriesBuilder)), modIds);
    }

    private static class_7225.class_7874 constructDatapackRegistries(class_7225.class_7874 original, class_7877 datapackEntriesBuilder) {
        HashSet<class_5321> builderKeys = new HashSet<class_5321>(datapackEntriesBuilder.field_40941.stream().map(class_7877.class_7884::comp_1144).toList());
        AbstractConditionalDatapackEntriesProvider.getDataPackRegistriesWithDimensions().filter(data -> !builderKeys.contains(data.comp_985())).forEach(data -> datapackEntriesBuilder.method_46777(data.comp_985(), context -> {}));
        return datapackEntriesBuilder.method_46781((class_5455)class_5455.method_40302((class_2378)class_7923.field_41167), original);
    }

    public abstract <T> Map<class_5321<T>, List<ConditionJsonProvider>> getConditions();

    public CompletableFuture<?> method_10319(class_7403 pOutput) {
        return this.registries.thenCompose(provider -> {
            class_6903 dynamicops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)provider);
            return CompletableFuture.allOf((CompletableFuture[])AbstractConditionalDatapackEntriesProvider.getDataPackRegistriesWithDimensions().flatMap(arg_0 -> this.lambda$run$5(pOutput, provider, (DynamicOps)dynamicops, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistry(class_7403 pOutput, class_7225.class_7874 pRegistries, DynamicOps<JsonElement> pOps, class_7655.class_7657<T> pRegistryData) {
        class_5321 resourcekey = pRegistryData.comp_985();
        return pRegistries.method_46759(resourcekey).map(lookup -> {
            class_7784.class_7489 packoutput$pathprovider = this.output.method_45973(class_7784.class_7490.field_39367, AbstractConditionalDatapackEntriesProvider.prefixNamespace(resourcekey.method_29177()));
            return CompletableFuture.allOf((CompletableFuture[])lookup.method_42017().filter(holder -> this.namespacePredicate.test(holder.method_40237().method_29177().method_12836())).map(reference -> {
                JsonArray conditions = new JsonArray();
                if (this.getConditions().containsKey(reference.method_40237())) {
                    for (ConditionJsonProvider c : this.getConditions().get(reference.method_40237())) {
                        conditions.add((JsonElement)c.toJson());
                    }
                }
                return AbstractConditionalDatapackEntriesProvider.dumpConditionalValue(packoutput$pathprovider.method_44107(reference.method_40237().method_29177()), pOutput, pOps, pRegistryData.comp_986(), reference.comp_349(), conditions);
            }).toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> dumpConditionalValue(Path pValuePath, class_7403 pOutput, DynamicOps<JsonElement> pOps, Encoder<E> pEncoder, E pValue, JsonArray conditions) {
        Optional optional = pEncoder.encodeStart(pOps, pValue).resultOrPartial(p_255999_ -> LOGGER.error("Couldn't serialize element {}: {}", (Object)pValuePath, p_255999_));
        if (optional.isPresent()) {
            JsonObject result = ((JsonElement)optional.get()).getAsJsonObject();
            if (!conditions.isJsonNull() && !conditions.isEmpty()) {
                result.add("fabric:load_conditions", (JsonElement)conditions);
            }
            return class_2405.method_10320((class_7403)pOutput, (JsonElement)result, (Path)pValuePath);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static Stream<class_7655.class_7657<?>> getDataPackRegistriesWithDimensions() {
        return Stream.concat(DATA_PACK_REGISTRIES_VIEW.stream(), class_7655.field_39969.stream());
    }

    private static String prefixNamespace(class_2960 registryKey) {
        return registryKey.method_12836().equals("minecraft") ? registryKey.method_12832() : registryKey.method_12836() + "/" + registryKey.method_12832();
    }

    private /* synthetic */ Stream lambda$run$5(class_7403 pOutput, class_7225.class_7874 provider, DynamicOps dynamicops, class_7655.class_7657 p_256552_) {
        return this.dumpRegistry(pOutput, provider, (DynamicOps<JsonElement>)dynamicops, p_256552_).stream();
    }
}

