/*
 * Decompiled with CFR 0.152.
 */
package cn.mmf.energyblade.energy;

import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;
import team.reborn.energy.api.EnergyStorage;

public class FEBladeStorage
extends SnapshotParticipant<Long>
implements EnergyStorage {
    protected long energy;
    protected long capacity;
    protected long maxReceive = 20000L;
    protected long maxExtract = 20000L;
    protected long powerupExtract;
    protected long standbyExtract;
    protected boolean energyDurability;
    protected boolean isPowered = false;

    public FEBladeStorage(long energy, long capacity, long powerupExtract, long standbyExtract, boolean energyDurability) {
        this.energy = energy;
        this.capacity = capacity;
        this.powerupExtract = powerupExtract;
        this.standbyExtract = standbyExtract;
        this.energyDurability = energyDurability;
    }

    public long insert(long maxReceive, TransactionContext context) {
        if (!this.supportsInsertion()) {
            return 0L;
        }
        long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (energyReceived > 0L) {
            this.updateSnapshots(context);
            this.energy += energyReceived;
            return energyReceived;
        }
        return 0L;
    }

    public long extract(long maxExtract, TransactionContext context) {
        if (!this.supportsExtraction()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (energyExtracted > 0L) {
            this.updateSnapshots(context);
            this.energy -= energyExtracted;
            if (this.energy <= 0L) {
                this.setPowered(false);
            }
            return energyExtracted;
        }
        return 0L;
    }

    public long getAmount() {
        return this.energy;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public boolean supportsInsertion() {
        return this.maxReceive > 0L;
    }

    public boolean supportsExtraction() {
        return this.maxExtract > 0L;
    }

    public boolean isEnergyDurability() {
        return this.energyDurability;
    }

    public void setEnergyDurability(boolean energyDurability) {
        this.energyDurability = energyDurability;
    }

    public long getPowerupExtract() {
        return this.powerupExtract;
    }

    public void setPowerupExtract(long powerupExtract) {
        this.powerupExtract = powerupExtract;
    }

    public long getStandbyExtract() {
        return this.standbyExtract;
    }

    public void setStandbyExtract(long standbyExtract) {
        this.standbyExtract = standbyExtract;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10544("Energy", this.energy);
        tag.method_10544("Capacity", this.capacity);
        tag.method_10544("MaxReceive", this.maxReceive);
        tag.method_10544("MaxExtract", this.maxExtract);
        tag.method_10544("PowerupExtract", this.powerupExtract);
        tag.method_10544("StandbyExtract", this.standbyExtract);
        tag.method_10556("EnergyDurability", this.energyDurability);
        tag.method_10556("isPowered", this.isPowered);
        return tag;
    }

    public void setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void deserializeNBT(class_2487 nbt) {
        if (nbt != null) {
            this.energy = nbt.method_10537("Energy");
            this.capacity = nbt.method_10537("Capacity");
            this.maxReceive = nbt.method_10537("MaxReceive");
            this.maxExtract = nbt.method_10537("MaxExtract");
            this.powerupExtract = nbt.method_10537("PowerupExtract");
            this.standbyExtract = nbt.method_10537("StandbyExtract");
            this.energyDurability = nbt.method_10577("EnergyDurability");
            this.isPowered = nbt.method_10577("isPowered");
        }
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
    }

    protected Long createSnapshot() {
        return this.getAmount();
    }

    protected void readSnapshot(Long snapshot) {
        this.energy = snapshot;
    }
}

