package cn.mmf.slashblade_addon.registry;

import cn.mmf.slashblade_addon.SlashBladeAddon;
import cn.mmf.slashblade_addon.entity.BlisteringSwordsEntity;
import cn.mmf.slashblade_addon.entity.EntityWaterDrive;
import cn.mmf.slashblade_addon.entity.GaleSwordsEntity;
import cn.mmf.slashblade_addon.entity.SpiralEdgeSwordsEntity;
import com.google.common.base.CaseFormat;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SBAEntitiesRegistry {
    public static final class_2960 BlisteringSwordsLoc = class_2960.method_60655(SlashBladeAddon.MODID,
            classToString(BlisteringSwordsEntity.class));
    public static final class_2960 SpiralEdgeSwordsLoc = class_2960.method_60655(SlashBladeAddon.MODID,
            classToString(SpiralEdgeSwordsEntity.class));
    public static final class_2960 GaleSwordsLoc = class_2960.method_60655(SlashBladeAddon.MODID,
            classToString(GaleSwordsEntity.class));

    public static class_1299<BlisteringSwordsEntity> BlisteringSwords;
    public static class_1299<SpiralEdgeSwordsEntity> SpiralEdgeSwords;
    public static class_1299<SpiralEdgeSwordsEntity> GaleSwords;
    public static class_1299<BlisteringSwordsEntity> LightingSwords;
    public static class_1299<EntityWaterDrive> WaterDrive;

    public static void init() {
        WaterDrive = register(class_2960.method_60655(SlashBladeAddon.MODID, "water_drive"), class_1299.class_1300
                .method_5903(EntityWaterDrive::new, class_1311.field_17715).method_17687(0.9F, 0.9F).method_27299(4)
                .method_27300(20)
                .method_5905("water_drive"));

        LightingSwords = register(class_2960.method_60655(SlashBladeAddon.MODID, "lighting_swords"), class_1299.class_1300
                .method_5903(BlisteringSwordsEntity::new, class_1311.field_17715).method_17687(0.9F, 0.9F).method_27299(4)
                .method_27300(20)
                .method_5905("lighting_swords"));

        BlisteringSwords = register(BlisteringSwordsLoc, class_1299.class_1300
                .method_5903(BlisteringSwordsEntity::new, class_1311.field_17715).method_17687(0.9F, 0.9F).method_27299(4)
                .method_27300(20)
                .method_5905(BlisteringSwordsLoc.toString()));

        SpiralEdgeSwords = register(SpiralEdgeSwordsLoc, class_1299.class_1300
                .method_5903(SpiralEdgeSwordsEntity::new, class_1311.field_17715).method_17687(0.9F, 0.9F).method_27299(4)
                .method_27300(20)
                .method_5905(SpiralEdgeSwordsLoc.toString()));

        GaleSwords = register(GaleSwordsLoc, class_1299.class_1300
                .method_5903(SpiralEdgeSwordsEntity::new, class_1311.field_17715).method_17687(0.9F, 0.9F).method_27299(4)
                .method_27300(20)
                .method_5905(GaleSwordsLoc.toString()));
    }

    private static String classToString(Class<? extends class_1297> entityClass) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_",
                "");
    }

    private static <T extends class_1297> class_1299<T> register(class_2960 loc, class_1299<T> type) {
        return class_2378.method_10230(class_7923.field_41177, loc, type);
    }
}
