package cn.mmf.slashblade_addon.specialattacks;

import cn.mmf.slashblade_addon.entity.EntityWaterDrive;
import cn.mmf.slashblade_addon.registry.SBAEntitiesRegistry;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5819;

public class WaterDrive {
    public static EntityDrive doSlash(class_1309 playerIn, float roll, int lifetime, class_243 centerOffset,
                                      boolean critical, double damage, float speed) {
        return doSlash(playerIn, roll, lifetime, centerOffset, critical, damage, KnockBacks.cancel, speed);
    }

    public static EntityDrive doSlash(class_1309 playerIn, float roll, int lifetime, class_243 centerOffset,
                                      boolean critical, double damage, KnockBacks knockback, float speed) {

        int colorCode = CapabilitySlashBlade.getBladeState(playerIn.method_6047())
                .map(ISlashBladeState::getColorCode).orElse(0xFF3333FF);

        return doSlash(playerIn, roll, lifetime, colorCode, centerOffset, critical, damage, knockback, speed);
    }

    private static void spawnParticle(class_2394 type, class_1309 player, int num, double rate) {
        class_1937 world = player.method_37908();
        class_5819 random = player.method_59922();

        for (int i = 0; i < num; ++i) {
            if (player.method_37908().method_8608())
                break;
            double xDist = (random.method_43057() * 2.0F - 1.0F);
            double yDist = (random.method_43057() * 2.0F - 1.0F);
            double zDist = (random.method_43057() * 2.0F - 1.0F);
            if (!(xDist * xDist + yDist * yDist + zDist * zDist > 1.0D)) {
                double x = player.method_23317()
                        + ((random.method_43058() * 2 - 1) * player.method_17681() - random.method_43059() * 0.02 * 10.0)
                        * rate;
                double y = player.method_23318();
                double z = player.method_23321()
                        + ((random.method_43058() * 2 - 1) * player.method_17681() - random.method_43059() * 0.02 * 10.0)
                        * rate;
                ((class_3218) world).method_14199(type, x, y, z, 0, xDist, yDist + 0.2D, zDist, 1);
            }
        }
    }

    public static EntityDrive doSlash(class_1309 playerIn, float roll, int lifetime, int colorCode, class_243 centerOffset,
                                      boolean critical, double damage, KnockBacks knockback, float speed) {

        if (playerIn.method_37908().method_8608())
            return null;

        playerIn.method_5783(class_3417.field_14998, 1.0f, 1.5f);

        if (playerIn.method_5809()) {
            playerIn.method_5783(class_3417.field_15222, 0.7f,
                    1.2f + 0.8f * playerIn.method_59922().method_43057());
            playerIn.method_46395();
        }

        WaterDrive.spawnParticle(class_2398.field_18306, playerIn, 30, 2.0F);

        class_243 lookAngle = playerIn.method_5720();
        class_243 pos = playerIn.method_19538().method_1031(0.0D, (double) playerIn.method_5751() * 0.75D, 0.0D)
                .method_1019(lookAngle.method_1021(0.3f));

        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0F, playerIn.method_5705(0)).method_1021(centerOffset.field_1351))
                .method_1019(VectorHelper.getVectorForRotation(0, playerIn.method_5705(0) + 90).method_1021(centerOffset.field_1350))
                .method_1019(lookAngle.method_1021(centerOffset.field_1350));
        EntityWaterDrive drive = new EntityWaterDrive(SBAEntitiesRegistry.WaterDrive, playerIn.method_37908());

        drive.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        drive.setDamage(damage);
        drive.setSpeed(speed);
        drive.method_7485(lookAngle.field_1352, lookAngle.field_1351, lookAngle.field_1350, drive.getSpeed(), 0);

        drive.method_7432(playerIn);
        drive.setRotationRoll(roll);

        drive.setColor(colorCode);
        drive.setIsCritical(critical);
        drive.setKnockBack(knockback);

        drive.setLifetime(lifetime);

        if (playerIn != null)
            CapabilityConcentrationRank.RANK_POINT.maybeGet(playerIn)
                    .ifPresent(rank -> drive.setRank(rank.getRankLevel(playerIn.method_37908().method_8510())));

        playerIn.method_37908().method_8649(drive);

        return drive;
    }
}
