package cn.mcmod_mmf.mmlib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7655;
import net.minecraft.class_7784;
import net.minecraft.class_7784.class_7490;
import net.minecraft.class_7877;
import net.minecraft.class_7923;
import org.slf4j.Logger;

import java.nio.file.Path;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class AbstractConditionalDatapackEntriesProvider implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_7784 output;
    private final CompletableFuture<class_7225.class_7874> registries;
    private final Predicate<String> namespacePredicate;

    private static final List<class_7655.class_7657<?>> DATA_PACK_REGISTRIES;
    private static final List<class_7655.class_7657<?>> DATA_PACK_REGISTRIES_VIEW;

    static {
        DATA_PACK_REGISTRIES = new ArrayList<>(class_7655.field_39968);
        DATA_PACK_REGISTRIES_VIEW = Collections.unmodifiableList(DATA_PACK_REGISTRIES);
    }


    public AbstractConditionalDatapackEntriesProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries, Set<String> modIds) {
        Predicate predicate;
        if (modIds == null) {
            predicate = (namespace) -> true;
        } else {
            Objects.requireNonNull(modIds);
            predicate = modIds::contains;
        }

        this.namespacePredicate = predicate;
        this.registries = registries;
        this.output = output;
    }

    public AbstractConditionalDatapackEntriesProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries, class_7877 datapackEntriesBuilder, Set<String> modIds) {
        this(output, registries.thenApply((r) -> constructDatapackRegistries(r, datapackEntriesBuilder)), modIds);
    }

    private static class_7225.class_7874 constructDatapackRegistries(class_7225.class_7874 original, class_7877 datapackEntriesBuilder) {
        HashSet<? extends class_5321<? extends class_2378<?>>> builderKeys = new HashSet<>(datapackEntriesBuilder.field_40941.stream().map(class_7877.class_7884::comp_1144).toList());

        getDataPackRegistriesWithDimensions().filter((data) -> !builderKeys.contains(data.comp_985())).forEach((data) -> datapackEntriesBuilder.method_46777(data.comp_985(), (context) -> {
        }));
        return datapackEntriesBuilder.method_46781(class_5455.method_40302(class_7923.field_41167), original);
    }

    public abstract <T> Map<class_5321<T>, List<ConditionJsonProvider>> getConditions();

    @Override
    public CompletableFuture<?> method_10319(class_7403 pOutput) {
        return this.registries.thenCompose((provider) -> {
            DynamicOps<JsonElement> dynamicops = class_6903.method_46632(JsonOps.INSTANCE, provider);
            return CompletableFuture.allOf(getDataPackRegistriesWithDimensions().flatMap((p_256552_) -> this.dumpRegistry(pOutput, provider, dynamicops, p_256552_).stream()).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistry(class_7403 pOutput, class_7225.class_7874 pRegistries, DynamicOps<JsonElement> pOps, class_7655.class_7657<T> pRegistryData) {
        class_5321<? extends class_2378<T>> resourcekey = pRegistryData.comp_985();
        return pRegistries.method_46759(resourcekey).map((lookup) -> {
            class_7784.class_7489 packoutput$pathprovider = this.output.method_45973(class_7490.field_39367, prefixNamespace(resourcekey.method_29177()));
            return CompletableFuture.allOf(lookup.method_42017().filter((holder) -> this.namespacePredicate.test(holder.method_40237().method_29177().method_12836())).map((reference) -> {
                JsonArray conditions = new JsonArray();
                if (this.getConditions().containsKey(reference.method_40237())) {
                    for (ConditionJsonProvider c : this.getConditions().get(reference.method_40237())) {
                        conditions.add(c.toJson());
                    }
                }

                return dumpConditionalValue(packoutput$pathprovider.method_44107(reference.method_40237().method_29177()), pOutput, pOps, pRegistryData.comp_986(), reference.comp_349(), conditions);
            }).toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> dumpConditionalValue(Path pValuePath, class_7403 pOutput, DynamicOps<JsonElement> pOps, Encoder<E> pEncoder, E pValue, JsonArray conditions) {
        Optional<JsonElement> optional = pEncoder.encodeStart(pOps, pValue).resultOrPartial((p_255999_) -> field_40831.error("Couldn't serialize element {}: {}", pValuePath, p_255999_));
        if (optional.isPresent()) {
            JsonObject result = optional.get().getAsJsonObject();
            if (!conditions.isJsonNull() && !conditions.isEmpty()) {
                result.add(ResourceConditions.CONDITIONS_KEY, conditions);
            }

            return class_2405.method_10320(pOutput, result, pValuePath);
        } else {
            return CompletableFuture.completedFuture(null);
        }
    }

    private static Stream<class_7655.class_7657<?>> getDataPackRegistriesWithDimensions() {
        return Stream.concat(DATA_PACK_REGISTRIES_VIEW.stream(), class_7655.field_39969.stream());
    }

    private static String prefixNamespace(class_2960 registryKey) {
        return registryKey.method_12836().equals("minecraft") ? registryKey.method_12832() : registryKey.method_12836() + "/" + registryKey.method_12832();
    }
}
