package cn.mmf.energyblade.client.render;

import cn.mmf.energyblade.energy.FEBladeStorage;
import cn.sh1rocu.sfaddons.util.ItemEnergyStorageHelper;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.SlashBladeTEISR;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_824;
import java.awt.*;

public class EnergyBladeBEWLR extends SlashBladeTEISR {
    public EnergyBladeBEWLR(class_824 p_172550_, class_5599 p_172551_) {
        super(p_172550_, p_172551_);
    }

    // 修改物品栏图标（若设置了能量替代耐久，物品栏图标的耐久显示则更改电量显示）
    @Override
    public void renderIcon(class_1799 stack, class_4587 matrixStack, class_4597 bufferIn, int lightIn, float scale,
                           boolean renderDurability) {
        ItemEnergyStorageHelper.fromStack(stack).filter(FEBladeStorage.class::isInstance)
                .map(FEBladeStorage.class::cast).ifPresentOrElse(energy -> {
                    if (!energy.isEnergyDurability()) {
                        super.renderIcon(stack, matrixStack, bufferIn, lightIn, scale, renderDurability);
                        return;
                    }
                    matrixStack.method_22905(scale, scale, scale);

                    class_2960 modelLocation = CapabilitySlashBlade.BLADESTATE.maybeGet(stack)
                            .filter(s -> s.getModel().isPresent()).map(s -> s.getModel().get())
                            .orElseGet(() -> stackDefaultModel(stack));
                    WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
                    class_2960 textureLocation = CapabilitySlashBlade.BLADESTATE.maybeGet(stack)
                            .filter(s -> s.getTexture().isPresent()).map(s -> s.getTexture().get())
                            .orElseGet(() -> stackDefaultTexture(stack));

                    String renderTarget = "item_blade";

                    BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn,
                            lightIn);
                    BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation,
                            matrixStack, bufferIn, lightIn);

                    if (renderDurability) {

                        WavefrontObject durabilityModel = BladeModelManager.getInstance()
                                .getModel(DefaultResources.resourceDurabilityModel);

                        float durability = 1 - (energy.getAmount() / (float) energy.getCapacity());
                        matrixStack.method_46416(0.0F, 0.0F, 0.1f);
                        Color aCol = new Color(0x404040);
                        Color bCol = new Color(0xA52C63);
                        int r = 0xFF & (int) class_3532.method_16439(aCol.getRed(), bCol.getRed(), durability);
                        int g = 0xFF & (int) class_3532.method_16439(aCol.getGreen(), bCol.getGreen(), durability);
                        int b = 0xFF & (int) class_3532.method_16439(aCol.getBlue(), bCol.getBlue(), durability);

                        BladeRenderState.setCol(new Color(r, g, b));
                        BladeRenderState.renderOverrided(stack, durabilityModel, "base",
                                DefaultResources.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);

                        matrixStack.method_46416(0.0F, 0.0F, -2.0f * durability);
                        BladeRenderState.renderOverrided(stack, durabilityModel, "color",
                                DefaultResources.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);

                    }
                }, () -> {
                    super.renderIcon(stack, matrixStack, bufferIn, lightIn, scale, renderDurability);
                });

    }
}
