package cn.mmf.slashblade_addon.entity;

import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.RayTraceHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import org.joml.Vector3f;

import java.util.Optional;
import java.util.stream.Stream;

public class BlisteringSwordsEntity extends EntityAbstractSummonedSword {
    private static final class_2940<Boolean> IT_FIRED = class_2945.method_12791(BlisteringSwordsEntity.class,
            class_2943.field_13323);
    private static final class_2940<Float> SPEED = class_2945.method_12791(BlisteringSwordsEntity.class,
            class_2943.field_13320);

    private static final class_2940<Vector3f> OFFSET = class_2945.method_12791(BlisteringSwordsEntity.class,
            class_2943.field_42237);
    long fireTime = -1;

    public BlisteringSwordsEntity(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);

        this.setPierce((byte) 5);
    }

    @Override
    protected void method_5693() {
        super.method_5693();

        this.field_6011.method_12784(IT_FIRED, false);
        this.field_6011.method_12784(SPEED, 3.0f);
        this.field_6011.method_12784(OFFSET, class_243.field_1353.method_46409());
    }

    public void doFire() {
        this.method_5841().method_12778(IT_FIRED, true);
    }

    public boolean itFired() {
        return this.method_5841().method_12789(IT_FIRED);
    }

    public void setSpeed(float speed) {
        this.method_5841().method_12778(SPEED, speed);
    }

    public float getSpeed() {
        return this.method_5841().method_12789(SPEED);
    }

    public void setOffset(class_243 offset) {
        this.method_5841().method_12778(OFFSET, offset.method_46409());
    }

    public class_243 getOffset() {
        return new class_243(this.method_5841().method_12789(OFFSET));
    }

    @Override
    public void method_5773() {
        if (!itFired() && method_5854() == null) {
            method_5873(this.method_24921(), true);
        }

        super.method_5773();
    }

    @Override
    public void method_5842() {
        if (itFired() && fireTime <= field_6012) {
            faceEntityStandby();
            class_1297 vehicle = method_5854();
            class_243 dir = this.method_5828(0);
            if (!(vehicle instanceof class_1309)) {
                this.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, getSpeed(), 1.0f);
                return;
            }

            class_1309 sender = (class_1309) method_5854();
            this.method_5848();

            this.field_6012 = 0;

            class_1937 worldIn = sender.method_37908();
            class_1297 lockTarget = null;
            if (sender instanceof class_1309) {
                lockTarget = CapabilitySlashBlade.BLADESTATE.maybeGet(sender.method_6047())
                        .filter(state -> state.getTargetEntity(worldIn) != null)
                        .map(state -> state.getTargetEntity(worldIn)).orElse(null);
            }

            Optional<class_1297> foundTarget = Stream
                    .of(Optional.ofNullable(lockTarget),
                            RayTraceHelper
                                    .rayTrace(sender.method_37908(), sender, sender.method_5836(1.0f),
                                            sender.method_5720(), 12, 12, (e) -> true)
                                    .filter(r -> r.method_17783() == class_239.class_240.field_1331).filter(r -> {
                                        class_3966 er = (class_3966) r;
                                        class_1297 target = er.method_17782();

                                        boolean isMatch = true;
                                        if (target instanceof class_1309)
                                            isMatch = TargetSelector.test.method_18419(sender, (class_1309) target);

                                        if (target instanceof IShootable)
                                            isMatch = ((IShootable) target).getShooter() != sender;

                                        return isMatch;
                                    }).map(r -> ((class_3966) r).method_17782()))
                    .filter(Optional::isPresent).map(Optional::get).findFirst();

            class_243 targetPos = foundTarget.map((e) -> new class_243(e.method_23317(), e.method_23318() + e.method_5751() * 0.5, e.method_23321()))
                    .orElseGet(() -> {
                        class_243 start = sender.method_5836(1.0f);
                        class_243 end = start.method_1019(sender.method_5720().method_1021(40));
                        class_239 result = worldIn.method_17742(new class_3959(start, end, class_3959.class_3960.field_17558,
                                class_3959.class_242.field_1348, sender));
                        return result.method_17784();
                    });

            class_243 pos = this.method_30950(0.0f);
            dir = targetPos.method_1020(pos).method_1029();

            this.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, getSpeed(), 1.0f);
            if (sender instanceof class_3222) {
                ((class_3222) sender).method_17356(class_3417.field_14550, class_3419.field_15248, 1.0F, 1.0F);
            }

            return;
        }

        this.method_18799(class_243.field_1353);
        // TODO
        // if (canUpdate())
        this.method_5670();

        faceEntityStandby();

        // lifetime check
        if (!itFired() && method_5854() instanceof class_1309) {
            if (field_6012 >= getDelay()) {
                fireTime = field_6012 + getDelay();
                doFire();
            }
        }
    }

    protected void faceEntityStandby() {
        class_243 pos = this.method_5854().method_19538();
        class_243 offset = this.getOffset();

        if (this.method_5854() == null) {
            doFire();
            return;
        }

        offset = offset.method_1037((float) Math.toRadians(-this.method_5854().method_36455()));
        offset = offset.method_1024((float) Math.toRadians(-this.method_5854().method_36454()));

        pos = pos.method_1019(offset);

        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();

        method_33574(pos);
        method_5710(-this.method_5854().method_36454(), -this.method_5854().method_36455());
    }

    @Override
    protected void method_7454(class_3966 result) {

        class_1297 targetEntity = result.method_17782();
        if (targetEntity instanceof class_1309) {
            KnockBacks.cancel.action.accept((class_1309) targetEntity);
            StunManager.setStun((class_1309) targetEntity);
        }

        super.method_7454(result);
    }
}
