package cn.mmf.slashblade_addon.item;

//import baguchan.tofucraft.api.tfenergy.IEnergyContained;
//import baguchan.tofucraft.api.tfenergy.IEnergyExtractable;
//import baguchan.tofucraft.api.tfenergy.IEnergyInsertable;

import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.item.ItemSlashBladeDetune;
import mods.flammpfeil.slashblade.item.SwordType;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.awt.*;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;

// TODO
// TofuCraft Fabric移植
public class TofuSlashBladeItem extends ItemSlashBladeDetune /*implements IEnergyContained, IEnergyExtractable, IEnergyInsertable*/ {
    private class_2960 model;
    private class_2960 texture;
    private final float baseAttack;
    public final int tfMax;

    public TofuSlashBladeItem(class_1832 tier, int attackDamageIn, float attackSpeedIn, int tfMax, class_1793 builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.tfMax = tfMax;
        this.baseAttack = (float) attackDamageIn;
        this.model = DefaultResources.resourceDefaultModel;
        this.texture = DefaultResources.resourceDefaultTexture;
    }

    @Override
    public void appendSlashArt(class_1799 stack, List<class_2561> tooltip, @NotNull ISlashBladeState s) {
        super.appendSlashArt(stack, tooltip, s);
    }

    // TODO
    // @Override
    public int getEnergy(class_1799 inst) {
        return inst.method_7969() != null && inst.method_7969().method_10545("tf_energy") ? inst.method_7969().method_10550("tf_energy") : 0;
    }

    public int getEnergyMax(class_1799 inst) {
        return this.tfMax;
    }

    public void setEnergy(class_1799 inst, int amount) {
        inst.method_7948().method_10569("tf_energy", amount);
    }

    public void setEnergyMax(class_1799 inst, int amount) {
    }

    private boolean getShowState(class_1799 stack) {
        final class_310 mcinstance = class_310.method_1551();
        return mcinstance.field_1724 != null && mcinstance.field_1724.method_5715() && this.getEnergy(stack) != 0;
    }

    public boolean method_31567(class_1799 p_150899_) {
        return this.getShowState(p_150899_) || super.method_31567(p_150899_);
    }

    public int method_31569(class_1799 stack) {
        return this.getShowState(stack) ? Math.round((float) this.getEnergy(stack) / (float) this.getEnergyMax(stack) * 13.0F) : super.method_31569(stack);
    }

    public int method_31571(class_1799 p_150901_) {
        return this.getShowState(p_150901_) ? Color.white.getRGB() : super.method_31571(p_150901_);
    }

    public void method_7851(class_1799 p_41421_, @Nullable class_1937 p_41422_, List<class_2561> p_41423_, class_1836 p_41424_) {
        super.method_7851(p_41421_, p_41422_, p_41423_, p_41424_);
        p_41423_.add(class_2561.method_43469("tooltip.tofucraft.energy", this.getEnergy(p_41421_), this.getEnergyMax(p_41421_)));
    }

    @Override
    public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
        if (this.getEnergy(stack) > 0 && amount > 0) {
            int damage = amount - this.drain(stack, amount, false);
            return super.damageItem(stack, damage, entity, onBroken);
        }

        return super.damageItem(stack, amount, entity, onBroken);
    }

    // TODO
    // @Override
    public int fill(class_1799 inst, int energy, boolean simulate) {
        int calculated = Math.min(energy, inst.method_7919());
        if (!simulate) {
            if (inst.method_7919() > 0) {
                inst.method_7974(class_3532.method_15340(inst.method_7919() - calculated, 0, inst.method_7936()));
                return calculated * 5;
            } else {
                int calculated2 = Math.min(energy, this.getEnergyMax(inst) - this.getEnergy(inst));
                this.setEnergy(inst, this.getEnergy(inst) + calculated2);
                return calculated2;
            }
        } else {
            return 0;
        }
    }

    // TODO
    // @Override
    public int drain(class_1799 inst, int amount, boolean simulate) {
        if (!simulate) {
            int calculated2 = Math.min(this.getEnergy(inst), amount);
            this.setEnergy(inst, this.getEnergy(inst) - calculated2);
            return calculated2;
        } else {
            return 0;
        }
    }

    public void appendSwordType(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        EnumSet<SwordType> swordType = SwordType.from(stack);
        if (swordType.contains(SwordType.BEWITCHED)) {
            tooltip.add(class_2561.method_43471("slashblade.sword_type.bewitched").method_27692(class_124.field_1064));
        } else if (swordType.contains(SwordType.ENCHANTED)) {
            tooltip.add(class_2561.method_43471("slashblade.sword_type.enchanted").method_27692(class_124.field_1062));
        } else {
            tooltip.add(class_2561.method_43471("slashblade.sword_type.noname").method_27692(class_124.field_1063));
        }

    }

    public class_2960 getModel() {
        return this.model;
    }

    public TofuSlashBladeItem setModel(class_2960 model) {
        this.model = model;
        return this;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public TofuSlashBladeItem setTexture(class_2960 texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public boolean isDestructable(class_1799 stack) {
        return false;
    }
}
