package cn.sh1rocu.sfaddons.util;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.minecraft.class_1799;
import team.reborn.energy.api.EnergyStorage;

import java.util.Optional;

public class ItemEnergyStorageHelper {
    public static Optional<EnergyStorage> fromStack(class_1799 stack) {
        ContainerItemContext context = ContainerItemContext.ofSingleSlot(new SingleStackStorage() {
            private class_1799 itemStack = stack;

            @Override
            protected class_1799 getStack() {
                return itemStack;
            }

            @Override
            protected void setStack(final class_1799 stack) {
                itemStack = stack;
            }

            @Override
            protected void onFinalCommit() {
                stack.method_7980(itemStack.method_7969());
            }
        });

        return Optional.ofNullable(EnergyStorage.ITEM.find(stack, context));
    }
}