package cn.mmf.slashblade_addon.specialattacks;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5819;

public class FireSpiral {
    private static void spawnParticle(class_2394 type, class_1309 player, int num, double rate) {
        class_1937 world = player.method_37908();
        class_5819 random = player.method_6051();

        for (int i = 0; i < num; ++i) {
            if (player.method_37908().method_8608())
                break;
            double xDist = (random.method_43057() * 2.0F - 1.0F);
            double yDist = (random.method_43057() * 2.0F - 1.0F);
            double zDist = (random.method_43057() * 2.0F - 1.0F);
            if (!(xDist * xDist + yDist * yDist + zDist * zDist > 1.0D)) {
                double x = player.method_23317()
                        + ((random.method_43058() * 2 - 1) * player.method_17681() - random.method_43059() * 0.02 * 10.0)
                        * rate;
                double y = player.method_23318();
                double z = player.method_23321()
                        + ((random.method_43058() * 2 - 1) * player.method_17681() - random.method_43059() * 0.02 * 10.0)
                        * rate;
                ((class_3218) world).method_14199(type, x, y, z, 0, xDist, yDist + 0.2D, zDist, 1);
            }
        }
    }

    public static void doCircleSlash(class_1309 living, float roll, float yRot) {
        if (living.method_37908().method_8608())
            return;

        class_1799 blade = living.method_6047();
        if (CapabilitySlashBlade.BLADESTATE.maybeGet(blade).isEmpty())
            return;
        float rot = living.method_36454() - 22.5F + yRot;

        SlashBladeEvent.DoSlashEvent event = new SlashBladeEvent.DoSlashEvent(blade,
                CapabilitySlashBlade.BLADESTATE.maybeGet(blade).orElseThrow(NullPointerException::new),
                living, roll, true, 1D, KnockBacks.cancel);
        event.setYRot(yRot);
        SlashBladeEvent.DO_SLASH.invoker().onDoSlash(event);
        if (event.isCanceled())
            return;

        spawnParticle(class_2398.field_27783, living, 25, 2.0F);

        class_243 pos = living.method_19538().method_1031(0.0D, (double) living.method_5751() * 0.75D, 0.0D)
                .method_1019(living.method_5720().method_1021(0.3f));

        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0F, living.method_5705(0)).method_1021(class_243.field_1353.field_1351))
                .method_1019(VectorHelper.getVectorForRotation(0, living.method_5705(0) + 90).method_1021(class_243.field_1353.field_1350))
                .method_1019(living.method_5720().method_1021(class_243.field_1353.field_1350));

        EntitySlashEffect jc = new EntitySlashEffect(SBEntityTypes.SlashEffect, living.method_37908()) {

            @Override
            public class_3414 getSlashSound() {
                return class_3417.field_42593;
            }
        };
        jc.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        jc.method_7432(event.getUser());

        jc.setRotationRoll(roll);
        jc.method_36456(rot);
        jc.method_36457(0);

        jc.setColor(0xFF0000);

        jc.setMute(false);
        jc.setIsCritical(event.isCritical());

        jc.setDamage(event.getDamage());

        jc.setKnockBack(event.getKnockback());

        if (living != null)
            CapabilityConcentrationRank.RANK_POINT.maybeGet(living)
                    .ifPresent(rank -> jc.setRank(rank.getRankLevel(living.method_37908().method_8510())));

        living.method_37908().method_8649(jc);
    }
}
