package cn.sh1rocu.sfaddons.mixin;

import cn.sh1rocu.sfaddons.api.extension.IDamageable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {
    @Shadow
    public abstract class_1792 getItem();

    @Shadow
    public abstract boolean isEmpty();

    @Shadow
    @Nullable
    public abstract class_2487 getTag();

    @Inject(method = "isDamageableItem", at = @At("HEAD"), cancellable = true)
    private void sf$isDamageable(CallbackInfoReturnable<Boolean> cir) {
        if (this.getItem() instanceof IDamageable damageable) {
            if (this.isEmpty())
                return;
            if (damageable.isDamageable((class_1799) (Object) this)) {
                class_2487 compoundtag = this.getTag();
                cir.setReturnValue(compoundtag == null || !compoundtag.method_10577("Unbreakable"));
            } else {
                cir.setReturnValue(false);
            }
        }
    }
}